/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.copy;

import com.datical.liquibase.ext.copy.ProjectCopier;
import java.io.File;
import liquibase.exception.UnexpectedLiquibaseException;

public class FileSystemProjectCopier
implements ProjectCopier {
    @Override
    public int getPriority(String path) {
        if (path == null) {
            return -1;
        }
        if (path.startsWith("/") || !path.contains(":")) {
            return 1;
        }
        if (path.startsWith("file:") || path.matches("^[A-Za-z]:.*")) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public File createWorkingStorage(String projectDir, boolean keepTempFiles) {
        File projectDirFile = new File(projectDir);
        boolean b = projectDirFile.mkdirs();
        if (!b && !projectDirFile.exists()) {
            throw new UnexpectedLiquibaseException("Unable to create project directory '" + projectDir + "'");
        }
        return projectDirFile;
    }

    @Override
    public void copy(String source, String target, boolean recursive) {
    }
}

