/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.condition;

import com.datical.liquibase.ext.flow.condition.OperatorFactory;
import com.datical.liquibase.ext.flow.condition.operator.ConditionOperator;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.util.StringUtil;

public class Condition {
    private final String leftOperand;
    private final ConditionOperator operator;
    private final String rightOperand;
    private final String rawConditionText;
    private static final OperatorFactory operatorFactory = (OperatorFactory)Scope.getCurrentScope().getSingleton(OperatorFactory.class);

    public Condition(String leftOperand, ConditionOperator operator, String rightOperand, String rawConditionText) {
        this.leftOperand = leftOperand;
        this.operator = operator;
        this.rightOperand = rightOperand;
        this.rawConditionText = rawConditionText;
    }

    public static Condition fromString(String condition, Map<String, Object> variables) {
        if (StringUtil.isEmpty((String)condition)) {
            return null;
        }
        List operators = Scope.getCurrentScope().getServiceLocator().findInstances(ConditionOperator.class);
        if (operators.isEmpty()) {
            throw new RuntimeException("No condition operators found.");
        }
        if (variables == null) {
            variables = Collections.emptyMap();
        }
        Map<String, Object> expandedCondition = FlowVariableExpander.expandVariables(Collections.singletonMap("if", condition), variables);
        condition = expandedCondition.get("if").toString();
        String regex = String.format("(?<leftOperand>.+)\\s*(?<operator>%s)\\s*(?<rightOperand>.+)", operators.stream().map(ConditionOperator::getTextualRepresentation).collect(Collectors.joining("|")));
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(condition.trim());
        if (matcher.matches()) {
            String operatorText = matcher.group("operator");
            ConditionOperator operator = operatorFactory.create(operatorText);
            if (operator == null) {
                throw new IllegalArgumentException("Operator '" + operatorText + "' not recognized.");
            }
            return new Condition(matcher.group("leftOperand").trim(), operator, matcher.group("rightOperand").trim(), condition);
        }
        throw new IllegalArgumentException("Condition '" + condition + "' cannot be parsed.");
    }

    public boolean evaluate() {
        return this.operator.evaluate(this.leftOperand, this.rightOperand);
    }

    public String getRawConditionText() {
        return this.rawConditionText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return this.leftOperand.equals(condition.leftOperand) && this.operator.getClass().equals(condition.operator.getClass()) && this.rightOperand.equals(condition.rightOperand);
    }

    public int hashCode() {
        return Objects.hash(this.leftOperand, this.operator, this.rightOperand);
    }
}

