/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.logging.structured.mdc.customobjects;

import com.datical.liquibase.ext.flow.file.FlowFileHelper;
import com.datical.liquibase.ext.flow.file.FlowFileLoad;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.FlowAction;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.FlowFilesNested;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.FlowStage;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.IncludeFile;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.Includes;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.NestedFile;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.Stages;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.resource.Resource;

public class FlowFileRoot
implements CustomMdcObject {
    public static final String END_STAGE = "endStage";
    private String name;
    private String path;
    private Map<String, Object> userMetadata;
    private Stages stages;
    private Includes includedFiles;
    private LinkedHashMap<String, Object> globalVariables;
    private FlowFilesNested flowFilesNested;

    public FlowFileRoot() {
    }

    public FlowFileRoot(String name, FlowFileLoad flowFileLoad, Map<String, Stage> flowFileStages, Stage endStage) {
        this.setName(name);
        this.setPath(this.getResourcePath(flowFileLoad.resource));
        this.setUserMetadata(flowFileLoad.flowFile.getUserMetadata());
        this.stages = new Stages();
        AtomicInteger stageCount = new AtomicInteger(1);
        flowFileStages.forEach((stageName, flowFileStage) -> {
            FlowStage stage = this.createFlowStage((String)stageName, (Stage)flowFileStage);
            this.stages.getStage().put(Integer.toString(stageCount.getAndIncrement()), stage);
        });
        this.addEndStage(endStage, stageCount);
        if (flowFileLoad.includes != null) {
            this.includedFiles = new Includes();
            this.includedFiles.setFileCount(flowFileLoad.includes.size());
            AtomicInteger includeCount = new AtomicInteger(1);
            flowFileLoad.includes.forEach((alias, fileResource) -> {
                IncludeFile include = new IncludeFile();
                include.name = alias;
                include.path = this.getResourcePath((Resource)fileResource);
                this.includedFiles.getFile().put(Integer.toString(includeCount.getAndIncrement()), include);
            });
        }
        if (flowFileLoad.globalVariables != null) {
            this.setGlobalVariables(flowFileLoad.globalVariables);
        }
        this.loadNestedFlowFiles(flowFileLoad);
    }

    private void loadNestedFlowFiles(FlowFileLoad flowFileLoad) {
        if (flowFileLoad.nestedFlowFiles == null) {
            this.flowFilesNested = new FlowFilesNested();
            this.flowFilesNested.setFileCount(0);
            return;
        }
        this.flowFilesNested = new FlowFilesNested();
        this.flowFilesNested.setFileCount(flowFileLoad.nestedFlowFiles.size());
        AtomicInteger nestedCount = new AtomicInteger(1);
        flowFileLoad.nestedFlowFiles.forEach((alias, rootStage) -> {
            NestedFile nestedFile = new NestedFile();
            nestedFile.name = alias;
            nestedFile.rootStage = rootStage;
            try {
                nestedFile.path = this.getResourcePath(FlowFileHelper.determineResource(alias));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.flowFilesNested.getFile().put(Integer.toString(nestedCount.getAndIncrement()), nestedFile);
        });
    }

    private FlowStage createFlowStage(String stageName, Stage flowFileStage) {
        FlowStage stage = new FlowStage();
        stage.setName(stageName);
        stage.setUserMetadata(flowFileStage != null ? flowFileStage.getUserMetadata() : null);
        if (flowFileStage != null && flowFileStage.getActions() != null) {
            this.createFlowAction(flowFileStage, stage);
        }
        return stage;
    }

    private void createFlowAction(Stage flowFileStage, FlowStage stage) {
        AtomicInteger actionCount = new AtomicInteger(1);
        stage.setStageVars(flowFileStage.getVariables());
        flowFileStage.getActions().forEach(flowFileAction -> {
            FlowAction action = new FlowAction();
            action.setType(flowFileAction.getType());
            action.setCommand(flowFileAction.getCommand());
            action.setUserMetadata(flowFileAction.getUserMetadata());
            stage.addAction(Integer.toString(actionCount.getAndIncrement()), action);
        });
    }

    private void addEndStage(Stage endStage, AtomicInteger count) {
        if (endStage != null) {
            FlowStage stage = new FlowStage();
            stage.setName(END_STAGE);
            this.stages.getStage().put(Integer.toString(count.getAndIncrement()), stage);
        }
    }

    private String getResourcePath(Resource resource) {
        return resource != null ? resource.getUri().toString().replace("file://", "") : null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Stages getStages() {
        return this.stages;
    }

    public void setStages(Stages stages) {
        this.stages = stages;
    }

    public Includes getIncludedFiles() {
        return this.includedFiles;
    }

    public void setIncludedFiles(Includes includedFiles) {
        this.includedFiles = includedFiles;
    }

    public Map<String, Object> getGlobalVariables() {
        return this.globalVariables;
    }

    public void setGlobalVariables(LinkedHashMap<String, Object> globalVariables) {
        this.globalVariables = globalVariables;
    }

    public FlowFilesNested getFlowFilesNested() {
        return this.flowFilesNested;
    }

    public void setFlowFilesNested(FlowFilesNested flowFilesNested) {
        this.flowFilesNested = flowFilesNested;
    }

    public Map<String, Object> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, Object> userMetadata) {
        this.userMetadata = userMetadata;
    }
}

