/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.sql.Sql;

public abstract class NativeExecutorRunner
extends ExecuteShellCommandChange {
    protected Sql[] sqlStrings;
    protected ChangeSet changeSet;

    protected NativeExecutorRunner() {
    }

    protected NativeExecutorRunner(Sql[] sqlStrings) {
        this.sqlStrings = sqlStrings;
    }

    protected void writeSqlStrings(BufferedWriter writer) throws IOException {
        for (Sql sql : this.sqlStrings) {
            String line = sql.toSql();
            line = line.replace("\r", "");
            writer.write(line + "\n");
        }
    }

    protected String getEndDelimiter() {
        Change change;
        String endDelimiter = null;
        List changes = this.changeSet.getChanges();
        Iterator iterator = changes.iterator();
        while (iterator.hasNext() && (!((change = (Change)iterator.next()) instanceof AbstractSQLChange) || (endDelimiter = ((AbstractSQLChange)change).getEndDelimiter()) == null)) {
        }
        return endDelimiter;
    }

    public Properties getPropertiesFromConf(ConfigFile configFile) {
        Properties properties = new Properties();
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        InputStream is = null;
        try {
            Resource resource = resourceAccessor.get(configFile.filename);
            if (!resource.exists()) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(String.format("No configuration file named '%s' found.", configFile.filename));
            } else {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(String.format("%s configuration file located at '%s'.", configFile.filename, resource.getUri()));
                is = resource.openInputStream();
                properties.load(is);
            }
        }
        catch (IOException ioe) {
            throw new UnexpectedLiquibaseException((Throwable)ioe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return properties;
    }

    public abstract String getIntegrationDisplayName();

    public static enum ConfigFile {
        PSQL("liquibase.psql.conf"),
        SQLCMD("liquibase.sqlcmd.conf"),
        SQLPLUS("liquibase.sqlplus.conf");

        private final String filename;

        private ConfigFile(String filename) {
            this.filename = filename;
        }
    }
}

