/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement;

import java.util.ArrayList;
import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;

public class ReturningClause
extends ArrayList<SelectItem<?>> {
    private Keyword keyword;
    private final List<Object> dataItems;

    public ReturningClause(Keyword keyword, List<SelectItem<?>> selectItems, List<Object> dataItems) {
        this.keyword = keyword;
        this.addAll(selectItems);
        this.dataItems = dataItems;
    }

    public ReturningClause(String keyword, List<SelectItem<?>> selectItems, List<Object> dataItems) {
        this(Keyword.from(keyword), selectItems, dataItems);
    }

    public ReturningClause(Keyword keyword, List<SelectItem<?>> selectItems) {
        this(keyword, selectItems, null);
    }

    public ReturningClause(String keyword, List<SelectItem<?>> selectItems) {
        this(Keyword.valueOf(keyword), selectItems, null);
    }

    public Keyword getKeyword() {
        return this.keyword;
    }

    public ReturningClause setKeyword(Keyword keyword) {
        this.keyword = keyword;
        return this;
    }

    public List<?> getDataItems() {
        return this.dataItems;
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        builder.append(" ").append((Object)this.keyword).append(" ");
        for (i = 0; i < this.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.get(i));
        }
        if (this.dataItems != null && this.dataItems.size() > 0) {
            builder.append(" INTO ");
            for (i = 0; i < this.dataItems.size(); ++i) {
                if (i > 0) {
                    builder.append(" ,");
                }
                builder.append(this.dataItems.get(i));
            }
        }
        return builder;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    static enum Keyword {
        RETURN,
        RETURNING;


        public static Keyword from(String keyword) {
            return Enum.valueOf(Keyword.class, keyword.toUpperCase());
        }
    }
}

