/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.merge;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;

public class MergeInsert
implements Serializable {
    private ExpressionList<Column> columns;
    private ExpressionList<Expression> values;
    private Expression whereCondition;

    public ExpressionList<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(ExpressionList<Column> columns) {
        this.columns = columns;
    }

    public ExpressionList<Expression> getValues() {
        return this.values;
    }

    public void setValues(ExpressionList<Expression> values) {
        this.values = values;
    }

    public Expression getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(Expression whereCondition) {
        this.whereCondition = whereCondition;
    }

    public String toString() {
        return " WHEN NOT MATCHED THEN INSERT " + (this.columns != null ? this.columns.toString() : "") + " VALUES " + this.values.toString() + (this.whereCondition != null ? " WHERE " + this.whereCondition : "");
    }

    public MergeInsert withColumns(ExpressionList<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public MergeInsert withValues(ExpressionList<Expression> values) {
        this.setValues(values);
        return this;
    }

    public MergeInsert addColumns(Column ... columns) {
        return this.addColumns(Arrays.asList(columns));
    }

    public MergeInsert addColumns(Collection<? extends Column> columns) {
        ExpressionList collection = Optional.ofNullable(this.getColumns()).orElseGet(() -> new ExpressionList((Expression[])new Column[0]));
        collection.addAll(columns);
        return this.withColumns(collection);
    }

    public MergeInsert addValues(Expression ... values) {
        return this.addValues(Arrays.asList(values));
    }

    public MergeInsert addValues(Collection<? extends Expression> values) {
        ExpressionList collection = Optional.ofNullable(this.getValues()).orElseGet(() -> new ExpressionList(new Expression[0]));
        collection.addAll(values);
        return this.withValues(collection);
    }

    public MergeInsert withWhereCondition(Expression whereCondition) {
        this.setWhereCondition(whereCondition);
        return this;
    }

    public <E extends Expression> E getWhereCondition(Class<E> type) {
        return (E)((Expression)type.cast(this.getWhereCondition()));
    }
}

