/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.StageEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicRule;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;

public class RequireChangesetIDIsValidUUID
extends AbstractLiquibaseBasicRule {
    private final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", 2);

    @Override
    public StageEnum getStage() {
        return StageEnum.FORECAST;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, BasicRule basicRule) {
        Matcher matcher = this.UUID_PATTERN.matcher(changeSet.getId());
        if (!matcher.matches()) {
            return this.putResultUnsuccessful(changeSet, "The changeset ID \"" + changeSet.getId() + "\" does not follow the required 8-4-4-4-12 pattern UUID or GUID pattern. Please review and update the changeset ID.", (AbstractConfigurableRule)basicRule);
        }
        return this.putResultSuccessful(changeSet, true, (AbstractConfigurableRule)basicRule);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, BasicRule basicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDescription() {
        return "Alerts when a changeset ID does not follow the 8-4-4-4-12 pattern of UUID or GUID.";
    }

    @Override
    public String getShortName() {
        return "RequireChangesetIDisUUID";
    }

    @Override
    public int getPriority() {
        return 580;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public String getName() {
        return "Require Changeset ID is valid UUID";
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }
}

