/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import com.datical.liquibase.ext.checks.config.cli.EnumGetter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class StringEnumListGetter<E extends Enum>
extends AbstractCommandLineValueGetter<String> {
    private final Class<E> e;
    private final boolean ignoreCase;

    public StringEnumListGetter(Class<E> e, boolean ignoreCase) {
        super(String.class);
        this.e = e;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean validate(String input) {
        StringEnumListGetter.split(input, this.e, this.ignoreCase);
        return true;
    }

    @Override
    public String convert(String input) {
        return input;
    }

    public static <T extends Enum<T>> List<T> split(String csv, Class<T> enumClass, boolean ignoreCase) {
        return Arrays.stream(csv.split(",")).map(name -> {
            if (ignoreCase) {
                return EnumGetter.getEnumIgnoreCase(name.trim().toUpperCase(), enumClass);
            }
            return Enum.valueOf(enumClass, name.trim());
        }).collect(Collectors.toList());
    }
}

