/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringListGetter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.dynamic.AbstractObjectNamingRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;

public abstract class AbstractObjectNamingListRule
extends AbstractObjectNamingRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        return this.doInternalEvaluate(changeSet.getChanges(), changeSet, dynamicRule, false);
    }

    private boolean doInternalEvaluate(List<Change> changes, ChangeSet changeSet, DynamicRule dynamicRule, boolean isRollback) {
        DynamicRuleParameter allowedListParameter = dynamicRule.getParameter(DynamicRuleParameterEnum.ALLOWED_LIST);
        List<String> allowedList = StringListGetter.split((String)allowedListParameter.getValue());
        dynamicRule.getParameters().add(new DynamicRuleParameter(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.EQUALS.toString()));
        Boolean sqlFailedToParse = null;
        Iterator<String> forbiddenWordsIterator = this.getForbiddenWords().iterator();
        while (forbiddenWordsIterator.hasNext() && (sqlFailedToParse == null || !sqlFailedToParse.booleanValue())) {
            String forbiddenWord = forbiddenWordsIterator.next();
            if (allowedList.contains(forbiddenWord)) continue;
            DynamicRuleParameter searchStringParam = new DynamicRuleParameter(DynamicRuleParameterEnum.SEARCH_STRING, forbiddenWord);
            dynamicRule.getParameters().add(searchStringParam);
            if (isRollback) {
                super.internalRollbackEvaluate(changeSet, changes, null, dynamicRule);
            } else {
                super.internalEvaluate(changeSet, dynamicRule);
            }
            dynamicRule.getParameters().remove(searchStringParam);
            if (sqlFailedToParse != null) continue;
            sqlFailedToParse = this.getResults().get(changeSet).hasSqlParseFailures();
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, isRollback);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        DynamicRuleParameter allowedListParameter = dynamicRule.getParameter(DynamicRuleParameterEnum.ALLOWED_LIST);
        List<String> allowedList = StringListGetter.split((String)allowedListParameter.getValue());
        dynamicRule.getParameters().add(new DynamicRuleParameter(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.EQUALS.toString()));
        for (String forbiddenWord : this.getForbiddenWords()) {
            if (allowedList.contains(forbiddenWord)) continue;
            DynamicRuleParameter searchStringParam = new DynamicRuleParameter(DynamicRuleParameterEnum.SEARCH_STRING, forbiddenWord);
            dynamicRule.getParameters().add(searchStringParam);
            super.internalEvaluate(databaseObject, dynamicRule);
            dynamicRule.getParameters().remove(searchStringParam);
        }
        return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)dynamicRule);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return this.doInternalEvaluate(changes, changeSet, dr, true);
    }

    @Override
    public boolean shouldParseSql() {
        return false;
    }

    @Override
    public boolean operatorMatchCallback(boolean matches) {
        return matches;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.OBJECT_TYPES), new RuleParameter<String>(DynamicRuleParameterEnum.ALLOWED_LIST, (value, newParameterValues) -> StringListGetter.validate(value, this.getForbiddenWords(), this.getAllowedListValidationErrorMessage()), null, null, true), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE));
    }

    public abstract Set<String> getForbiddenWords();

    public abstract String getAllowedListValidationErrorMessage();

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule.SupportedChangesetFormats.MODELED;
    }
}

