/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksCopyCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksEnableCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.List;
import liquibase.Scope;
import liquibase.command.CommandResultsBuilder;
import liquibase.exception.CommandExecutionException;

public abstract class AbstractChecksStateModificationCommand
extends AbstractChecksCommandStep {
    protected CheckSettingsConfig csc = null;

    public final boolean doWork(CommandResultsBuilder resultsBuilder, String checksSettingsFile, String checkName, String autoUpdate, Boolean autoEnableNewChecks) throws Exception {
        AbstractConfigurableRule rule;
        List<AbstractLiquibaseRule> instances = AbstractChecksStateModificationCommand.listAllRules();
        CheckSettingsConfigHelper helper = new CheckSettingsConfigHelper(checksSettingsFile, autoUpdate, autoEnableNewChecks);
        this.csc = helper.read(instances);
        this.throwExceptionIfPackageFile(this.csc);
        if (this.csc == null) {
            resultsBuilder.addResult("statusCode", (Object)0);
            return false;
        }
        AbstractLiquibaseRule installedRule = null;
        List<AbstractLiquibaseRule> rules = AbstractChecksStateModificationCommand.listAllRules();
        try {
            installedRule = AbstractChecksStateModificationCommand.findRuleByShortName(rules, checkName);
            rule = this.csc.getRuleById(installedRule.getId());
        }
        catch (CommandExecutionException cee) {
            rule = this.csc.getDynamicConfigurableRuleByShortName(checkName, "does not exist. Run 'liquibase checks show' to see a list of available checks.\n");
        }
        if (installedRule != null && !installedRule.hasDefaultParameterValues() && this instanceof ChecksEnableCommandStep) {
            Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "This check can not be enabled directly because one or more fields does not have a default value.  Create a copy of this check and initiate the customization workflow.");
            ChecksCopyCommandStep.doCopy(this.csc, checkName, rules, resultsBuilder, helper);
            return false;
        }
        if (!this.validateStateModification(rule, checkName)) {
            ChecksShowCommandStep.writeTableToOutput(resultsBuilder, this.csc, false);
            this.csc.outputWarningMessage();
            resultsBuilder.addResult("statusCode", (Object)0);
            return false;
        }
        this.doStateModification(rule);
        helper.write(this.csc);
        Scope.getCurrentScope().getUI().sendMessage(String.format("%n%nCheck '%s' has been %s.%n", checkName, this.describeStateModification()));
        ChecksShowCommandStep.writeTableToOutput(resultsBuilder, this.csc, false);
        this.csc.outputWarningMessage();
        return true;
    }

    public abstract boolean validateStateModification(AbstractConfigurableRule var1, String var2);

    public abstract void doStateModification(AbstractConfigurableRule var1);

    protected void modifyChecksInChain(AbstractConfigurableRule configurableRule, boolean state) {
        if (!(configurableRule instanceof DynamicRule)) {
            return;
        }
        DynamicRule dr = (DynamicRule)configurableRule;
        if (!dr.isChained()) {
            return;
        }
        if (dr.getParameter(DynamicRuleParameterEnum.LOGIC_CONDITIONAL).getValue() == null) {
            Scope.getCurrentScope().getUI().sendMessage(String.format("%n%s", "This chained check can not be enabled directly because it has not been customized.  Create a copy of this check and initiate the customization workflow."));
            return;
        }
        List<String> checks = dr.listChecksInChain();
        checks.forEach(c -> {
            AbstractConfigurableRule rule = this.csc.getRuleByShortName((String)c);
            if (!rule.isEnabled()) {
                rule.setEnabled(state);
                Scope.getCurrentScope().getUI().sendMessage(String.format("%n%nCheck '%s' has been %s.%n", rule.getShortName(), this.describeStateModification()));
            }
        });
    }

    public abstract String describeStateModification();
}

