/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksStateModificationCommand;
import com.datical.liquibase.ext.command.helpers.ChecksAutoEnableNewChecksArgument;
import com.datical.liquibase.ext.command.helpers.ChecksAutoUpdateArgument;
import java.util.Arrays;
import java.util.List;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;

public class ChecksEnableCommandStep
extends AbstractChecksStateModificationCommand {
    public static final String[] COMMAND_NAME = new String[]{"checks", "enable"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(ChecksAutoUpdateArgument.class, ChecksAutoEnableNewChecksArgument.class);
    }

    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        Boolean autoEnableNewChecks;
        String autoUpdate;
        String checkName;
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String checksSettingsFile = (String)commandScope.getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        if (!this.doWork(resultsBuilder, checksSettingsFile, checkName = (String)commandScope.getConfiguredValue(CHECK_NAME_ARG).getValue(), autoUpdate = (String)commandScope.getDependency(ChecksAutoUpdateArgument.class), autoEnableNewChecks = (Boolean)commandScope.getDependency(ChecksAutoEnableNewChecksArgument.class))) {
            return;
        }
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    @Override
    public boolean validateStateModification(AbstractConfigurableRule rule, String checkName) {
        if (rule.isEnabled()) {
            String message = String.format("%n%nCheck '%s' is already %s.  No changes made.%n", checkName, this.describeStateModification());
            Scope.getCurrentScope().getUI().sendMessage(message);
            return false;
        }
        return true;
    }

    @Override
    public void doStateModification(AbstractConfigurableRule configuredRule) {
        configuredRule.setEnabled(true);
        this.modifyChecksInChain(configuredRule, true);
    }

    @Override
    public String describeStateModification() {
        return "enabled";
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Enable a disabled check for current configuration");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = builder.argument("checkName", String.class).required().description("Name of check to enable").build();
        CHECKS_SETTINGS_FILE_ARG = builder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
    }
}

