/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import liquibase.Scope;
import liquibase.util.StringUtil;

public enum ChecksOutput {
    all(null),
    issues(null),
    issues0(SeverityEnum.INFO),
    issues1(SeverityEnum.MINOR),
    issues2(SeverityEnum.MAJOR),
    issues3(SeverityEnum.CRITICAL),
    issues4(SeverityEnum.BLOCKER),
    validated(null),
    checksrun(null),
    sqlparserfails(null),
    skippedchecks(null),
    nonApplicableChecks(null);

    private final SeverityEnum correspondingSeverityEnum;
    public static final Set<ChecksOutput> SEVERITY_RELATED_KEYS;

    private ChecksOutput(SeverityEnum correspondingSeverityEnum) {
        this.correspondingSeverityEnum = correspondingSeverityEnum;
    }

    public SeverityEnum getCorrespondingSeverityEnum() {
        return this.correspondingSeverityEnum;
    }

    public boolean isSeverityRelated() {
        return SEVERITY_RELATED_KEYS.contains((Object)this);
    }

    public static LinkedHashSet<ChecksOutput> parseAndValidateArgumentsString(String arg, String format) {
        if (ChecksRunCommandStep.isJsonOutput(format) && !arg.equals(ChecksRunCommandStep.CHECKS_OUTPUT_ARG.getDefaultValue())) {
            Scope.getCurrentScope().getUI().sendMessage("The values specified for the " + ChecksRunCommandStep.CHECKS_OUTPUT_ARG.getName() + " argument will be ignored because the output format is set to JSON.");
        }
        List argSplits = StringUtil.splitAndTrim((String)arg.toLowerCase(), (String)",");
        LinkedHashSet<ChecksOutput> checksOutputs = new LinkedHashSet<ChecksOutput>(argSplits.size());
        for (String argSplit : argSplits) {
            checksOutputs.add(ChecksOutput.valueOf(argSplit));
        }
        if (checksOutputs.contains((Object)all) && checksOutputs.size() > 1) {
            throw new IllegalArgumentException("If '" + (Object)((Object)all) + "' is specified, no other checksOutput arguments can be specified.");
        }
        return checksOutputs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldDisplayIssues(LinkedHashSet<ChecksOutput> checksOutputs) {
        if (checksOutputs == null) return true;
        if (checksOutputs.isEmpty()) return true;
        if (checksOutputs.contains((Object)all)) return true;
        if (checksOutputs.contains((Object)issues)) return true;
        if (!checksOutputs.stream().anyMatch(SEVERITY_RELATED_KEYS::contains)) return false;
        return true;
    }

    static {
        SEVERITY_RELATED_KEYS = new HashSet<ChecksOutput>(Arrays.asList(issues0, issues1, issues2, issues3, issues4));
    }
}

