/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.file;

import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.condition.Condition;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.FlowFileDTO;
import com.datical.liquibase.ext.flow.file.FlowFileLoad;
import com.datical.liquibase.ext.flow.file.FlowFileYaml;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.flow.file.StageDTO;
import com.datical.liquibase.ext.util.ResourceUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.util.CollectionUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.Yaml;

public class FlowFileHelper {
    private static final FlowFileYaml ffy = new FlowFileYaml();
    private static final Map<String, Action> cachedActions = Scope.getCurrentScope().getServiceLocator().findInstances(Action.class).stream().collect(Collectors.toMap(Action::getType, action -> action));

    private FlowFileHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlowFileLoad load(String yamlFilePath, boolean skipMissingProperties, Map<String, Object> inheritedVariables) throws IOException {
        FlowFileLoad flowFileLoad;
        block12: {
            Resource resource;
            FlowFileLoad flowFileLoad2 = new FlowFileLoad();
            PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
            InputStream inputStream = null;
            if (ResourceUtil.isAbsolute(yamlFilePath)) {
                flowFileLoad2.resource = resource = pathHandlerFactory.getResource(yamlFilePath);
                boolean exists = resource.exists();
                if (exists) {
                    inputStream = resource.openInputStream();
                }
            } else {
                flowFileLoad2.resource = resource = ResourceUtil.getResource(yamlFilePath);
                inputStream = ResourceUtil.getResourceInputStream(resource);
            }
            try {
                if (inputStream == null) {
                    throw new FileNotFoundException(yamlFilePath + " does not exist.");
                }
                ffy.setSkipMissingProperties(skipMissingProperties);
                String contents = StreamUtil.readStreamAsString((InputStream)inputStream);
                if (StringUtil.isEmpty((String)contents)) {
                    throw new CommandExecutionException(String.format("Flow file %s contents are empty", yamlFilePath));
                }
                FlowFileDTO dto = (FlowFileDTO)ffy.load(contents);
                flowFileLoad2.flowFile = FlowFileHelper.load(dto, inheritedVariables);
                FlowFileHelper.addIncludeFiles(flowFileLoad2, dto);
                flowFileLoad2.globalVariables = dto.getGlobalVariables();
                flowFileLoad = flowFileLoad2;
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            inputStream.close();
        }
        return flowFileLoad;
    }

    private static void addIncludeFiles(FlowFileLoad loadDTO, FlowFileDTO dto) throws IOException {
        if (dto.getInclude() == null) {
            return;
        }
        for (Map.Entry<String, String> include : dto.getInclude().entrySet()) {
            String alias = include.getKey();
            String filePath = include.getValue();
            Resource resource = ResourceUtil.getResource(filePath);
            if (loadDTO.includes == null) {
                loadDTO.includes = new LinkedHashMap<String, Resource>();
            }
            loadDTO.includes.put(alias, resource);
        }
    }

    public static Resource determineResource(String yamlFilePath) throws IOException {
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        Resource resource = null;
        resource = ResourceUtil.isAbsolute(yamlFilePath) ? pathHandlerFactory.getResource(yamlFilePath) : ResourceUtil.getResource(yamlFilePath);
        return resource;
    }

    public static boolean exists(String yamlFilePath) {
        try {
            return ResourceUtil.getResource(yamlFilePath).exists();
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException(e.getMessage(), (Throwable)e);
        }
    }

    public static FlowFile load(FlowFileDTO dto, Map<String, Object> inheritedVariables) {
        FlowFile flowFile = new FlowFile(inheritedVariables);
        LinkedHashMap<String, Object> globals = new LinkedHashMap<String, Object>();
        if (dto.getGlobalVariables() != null) {
            globals.putAll(dto.getGlobalVariables());
        }
        flowFile.setGlobalVariables(globals);
        flowFile.setIncludedVariables(FlowFileHelper.getIncludedVariables(dto.getInclude()));
        if (dto.getUserMetadata() != null) {
            Map<String, Object> expandedUserMetadata = FlowVariableExpander.expandVariables(dto.getUserMetadata(), flowFile.getAllVariables());
            expandedUserMetadata.forEach(flowFile::addUserMetadata);
        }
        if (dto.getStages() != null) {
            for (Map.Entry<String, StageDTO> stageDTOEntry : dto.getStages().entrySet()) {
                FlowFileHelper.processStage(stageDTOEntry, flowFile);
            }
        }
        flowFile.setEndStage(FlowFileHelper.processStage(dto.getEndStage(), flowFile.getAllVariables()));
        return flowFile;
    }

    private static LinkedHashMap<String, Object> getIncludedVariables(LinkedHashMap<String, String> includes) {
        if (includes == null) {
            return null;
        }
        LinkedHashMap<String, Object> includedVariables = new LinkedHashMap<String, Object>();
        Yaml yaml = new Yaml();
        for (Map.Entry<String, String> include : includes.entrySet()) {
            try {
                String alias = include.getKey();
                String filePath = include.getValue();
                if (!FlowFileHelper.exists(filePath)) {
                    throw new FileNotFoundException("Included file not found " + filePath);
                }
                Resource resource = ResourceUtil.getResource(filePath);
                String contents = StreamUtil.readStreamAsString((InputStream)resource.openInputStream());
                if (StringUtil.isEmpty((String)contents)) {
                    throw new CommandExecutionException("Included file " + filePath + " is empty");
                }
                Map load = (Map)yaml.load(contents);
                for (Map.Entry includedVariable : load.entrySet()) {
                    Object value = includedVariable.getValue();
                    String key = (String)includedVariable.getKey();
                    includedVariables.put(alias + "." + key, value);
                }
            }
            catch (Exception e) {
                String errorMessage = String.format("Error during setup: %s", e.getMessage());
                Scope.getCurrentScope().getUI().sendMessage(errorMessage);
                Scope.getCurrentScope().getLog(FlowFileHelper.class).severe(errorMessage, (Throwable)e);
            }
        }
        return includedVariables;
    }

    public static String createDefaultFlowFile(String defaultFlowFile) throws IOException {
        return FlowFileHelper.createDefaultFlowFile(defaultFlowFile, defaultFlowFile);
    }

    public static String createDefaultFlowFile(String flowFileName, String destinationFilename) throws IOException {
        block26: {
            PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
            if (pathHandlerFactory.getResource(destinationFilename).exists()) {
                throw new IOException("The specified file " + destinationFilename + " already exists.");
            }
            try (InputStream inputStream = FlowFileHelper.class.getClassLoader().getResourceAsStream("liquibase/flow/" + flowFileName);){
                if (inputStream != null) {
                    String flowFileAsString = StreamUtil.readStreamAsString((InputStream)inputStream);
                    try (OutputStream outputStream = pathHandlerFactory.createResource(destinationFilename);){
                        outputStream.write(flowFileAsString.getBytes());
                        break block26;
                    }
                }
                throw new FileNotFoundException("Flow file " + flowFileName + " provided by Liquibase cannot be located.");
            }
        }
        return destinationFilename;
    }

    public static String createDefaultFlowFileAtPath(String flowFileName, String destinationFilePath) throws IOException {
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        Throwable throwable = null;
        try (InputStream inputStream = FlowFileHelper.class.getClassLoader().getResourceAsStream("liquibase/flow/" + flowFileName);){
            if (inputStream != null) {
                String string;
                String flowFileAsString = StreamUtil.readStreamAsString((InputStream)inputStream);
                Resource folder = pathHandlerFactory.getResource(destinationFilePath);
                Resource file = folder.resolve(flowFileName);
                if (file.exists()) {
                    throw new IOException("The specified file " + file.getPath() + " already exists.");
                }
                try (OutputStream outputStream = file.openOutputStream(new OpenOptions());){
                    outputStream.write(flowFileAsString.getBytes());
                }
                if (destinationFilePath.endsWith("/")) {
                    string = destinationFilePath + flowFileName;
                    return string;
                }
                string = destinationFilePath + "/" + flowFileName;
                return string;
            }
            try {
                throw new FileNotFoundException("Flow file " + flowFileName + " provided by Liquibase cannot be located.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static Stage processStage(StageDTO stageDTO, LinkedHashMap<String, Object> variables) {
        if (stageDTO == null) {
            return null;
        }
        Stage newStage = new Stage();
        for (Map action : CollectionUtil.createIfNull(stageDTO.getActions())) {
            newStage.getActions().add(FlowFileHelper.generateAction(action, variables));
        }
        newStage.setGlobalArgs(FlowVariableExpander.expandVariables(stageDTO.getGlobalArgs(), variables));
        if (StringUtil.isNotEmpty((String)stageDTO.getCondition())) {
            newStage.setCondition(Condition.fromString(stageDTO.getCondition(), variables));
        }
        if (stageDTO.getUserMetadata() != null) {
            Map<String, Object> expandedUserMetadata = FlowVariableExpander.expandVariables(stageDTO.getUserMetadata(), variables);
            expandedUserMetadata.forEach(newStage::addUserMetadata);
        }
        newStage.getVariables().putAll(stageDTO.getStageVariables());
        return newStage;
    }

    private static void processStage(Map.Entry<String, StageDTO> stageDTOEntry, FlowFile flowFile) {
        LinkedHashMap<String, Object> variables = flowFile.getAllVariables();
        StageDTO stageDTO = stageDTOEntry.getValue();
        if (stageDTO != null) {
            Map<String, Object> stageVariables = stageDTO.getStageVariables();
            if (variables != null && stageVariables != null) {
                variables.putAll(stageVariables);
            }
        }
        Stage newStage = FlowFileHelper.processStage(stageDTO, variables);
        String stageName = stageDTOEntry.getKey();
        flowFile.getStages().put(stageName, newStage);
    }

    private static Action generateAction(Map<String, Object> actionMap, Map<String, Object> variables) {
        Action action;
        String type;
        String string = type = actionMap.containsKey("type") ? (String)actionMap.get("type") : "liquibase";
        if (StringUtil.isEmpty((String)type)) {
            type = "liquibase";
        }
        if ((action = FlowFileHelper.findAction(type)) == null) {
            throw new UnexpectedLiquibaseException("Unable to locate action '" + type + "'");
        }
        Map<String, Object> expandedVariables = FlowVariableExpander.execShellCommandsToExpand(variables);
        Action generatedAction = action.fromAction(actionMap, expandedVariables);
        generatedAction.setCondition(actionMap, variables);
        return generatedAction;
    }

    private static Action findAction(String type) {
        return FlowFileHelper.findAllActions().get(type);
    }

    private static Map<String, Action> findAllActions() {
        return cachedActions;
    }
}

