/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports.checks;

import com.datical.liquibase.ext.reports.checks.ChangelogChecksRunInfo;
import com.datical.liquibase.ext.reports.checks.ChecksRunReportOperationInfo;
import com.datical.liquibase.ext.reports.checks.DatabaseChecksRunInfo;
import com.datical.liquibase.ext.reports.checks.DetailedChecksRunInfo;
import com.datical.liquibase.ext.reports.checks.TriggeredCheck;
import com.datical.liquibase.ext.reports.checks.TriggeredCheckCount;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import liquibase.report.CustomData;
import liquibase.report.DatabaseInfo;
import liquibase.report.RuntimeInfo;
import liquibase.report.UpdateRollbackReportParameters;
import liquibase.util.StringUtil;

public class ChecksRunReportParameters
implements UpdateRollbackReportParameters {
    private String changelogArgValue;
    private String jdbcUrl;
    private String commandTitle = "Checks run";
    private final Date date = new Date();
    private final DatabaseInfo databaseInfo = new DatabaseInfo();
    private final RuntimeInfo runtimeInfo = new RuntimeInfo();
    private final ChecksRunReportOperationInfo operationInfo = new ChecksRunReportOperationInfo();
    private final CustomData customData = new CustomData();
    private final ChangelogChecksRunInfo changelogChecksRunInfo = new ChangelogChecksRunInfo();
    private final DatabaseChecksRunInfo databaseChecksRunInfo = new DatabaseChecksRunInfo();

    public List<DetailedChecksRunInfo> getDetailedChecksRunInfo() {
        Set<ChangelogChecksRunInfo.ChangeSetCheckResults> changeSetResults = this.getChangelogChecksRunInfo().getChangeSetCheckResults();
        Set<DatabaseChecksRunInfo.DatabaseCheckResults> databaseResults = this.getDatabaseChecksRunInfo().getDatabaseCheckResults();
        HashMap runInfoMap = new HashMap();
        changeSetResults.forEach(changeSetCheckResults -> changeSetCheckResults.getTriggeredChecks().forEach(triggeredCheck -> {
            DetailedChecksRunInfo detailedChecksRunInfo = this.buildBaseDetailedChecksRunInfo(StringUtil.upperCaseFirst((String)ScopeEnum.CHANGELOG.name().toLowerCase()), (TriggeredCheck)triggeredCheck);
            runInfoMap.computeIfAbsent(triggeredCheck.getCheckName(), id -> detailedChecksRunInfo).getRanAgainst().add(new DetailedChecksRunInfo.RanAgainst(changeSetCheckResults.getChangeSetId(), ScopeEnum.CHANGELOG, null, changeSetCheckResults.getChangeSetAuthor(), changeSetCheckResults.getChangeSetFilePath()));
            runInfoMap.computeIfPresent(triggeredCheck.getCheckName(), (uuid, runInfo) -> {
                runInfo.setChangesetCount(runInfo.getChangesetCount() + 1);
                runInfo.mergeSeverity(detailedChecksRunInfo);
                return runInfo;
            });
        }));
        databaseResults.forEach(databaseCheckResults -> databaseCheckResults.getTriggeredChecks().forEach(triggeredCheck -> {
            DetailedChecksRunInfo detailedChecksRunInfo = this.buildBaseDetailedChecksRunInfo(StringUtil.upperCaseFirst((String)ScopeEnum.DATABASE.name().toLowerCase()), (TriggeredCheck)triggeredCheck);
            runInfoMap.computeIfAbsent(triggeredCheck.getCheckName(), id -> detailedChecksRunInfo).getRanAgainst().add(new DetailedChecksRunInfo.RanAgainst(databaseCheckResults.getObject(), ScopeEnum.DATABASE, databaseCheckResults.getType(), null, null));
            runInfoMap.computeIfPresent(triggeredCheck.getCheckName(), (uuid, runInfo) -> {
                runInfo.setDatabaseObjectCount(runInfo.getDatabaseObjectCount() + 1);
                runInfo.mergeSeverity(detailedChecksRunInfo);
                return runInfo;
            });
        }));
        return new ArrayList<DetailedChecksRunInfo>(runInfoMap.values());
    }

    public TriggeredCheckCount getTotalTriggeredCheckCount() {
        TriggeredCheckCount changelogCheckCount = this.getChangelogChecksRunInfo().getTriggeredCheckCount();
        TriggeredCheckCount databaseCheckCount = this.getDatabaseChecksRunInfo().getTriggeredCheckCount();
        return TriggeredCheckCount.add(changelogCheckCount, databaseCheckCount);
    }

    private DetailedChecksRunInfo buildBaseDetailedChecksRunInfo(String scope, TriggeredCheck triggeredCheck) {
        DetailedChecksRunInfo detailedChecksRunInfo = new DetailedChecksRunInfo();
        detailedChecksRunInfo.setName(triggeredCheck.getCheckName());
        detailedChecksRunInfo.setParameters(triggeredCheck.getParameters());
        detailedChecksRunInfo.setScope(scope);
        detailedChecksRunInfo.setInfo(triggeredCheck.getInfo());
        detailedChecksRunInfo.setMinor(triggeredCheck.getMinor());
        detailedChecksRunInfo.setMajor(triggeredCheck.getMajor());
        detailedChecksRunInfo.setCritical(triggeredCheck.getCritical());
        detailedChecksRunInfo.setBlocker(triggeredCheck.getBlocker());
        detailedChecksRunInfo.setDescription(triggeredCheck.getDescription());
        detailedChecksRunInfo.setChainedCheckResults(triggeredCheck.getChainedCheckResults());
        detailedChecksRunInfo.setExpandedChainedCheck(triggeredCheck.getExpandedChainedCheck());
        detailedChecksRunInfo.setValidChain(triggeredCheck.getValidChain());
        return detailedChecksRunInfo;
    }

    public String getChangelogArgValue() {
        return this.changelogArgValue;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getCommandTitle() {
        return this.commandTitle;
    }

    public Date getDate() {
        return this.date;
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    public RuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }

    public ChecksRunReportOperationInfo getOperationInfo() {
        return this.operationInfo;
    }

    public CustomData getCustomData() {
        return this.customData;
    }

    public ChangelogChecksRunInfo getChangelogChecksRunInfo() {
        return this.changelogChecksRunInfo;
    }

    public DatabaseChecksRunInfo getDatabaseChecksRunInfo() {
        return this.databaseChecksRunInfo;
    }

    public void setChangelogArgValue(String changelogArgValue) {
        this.changelogArgValue = changelogArgValue;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setCommandTitle(String commandTitle) {
        this.commandTitle = commandTitle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChecksRunReportParameters)) {
            return false;
        }
        ChecksRunReportParameters other = (ChecksRunReportParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$changelogArgValue = this.getChangelogArgValue();
        String other$changelogArgValue = other.getChangelogArgValue();
        if (this$changelogArgValue == null ? other$changelogArgValue != null : !this$changelogArgValue.equals(other$changelogArgValue)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$commandTitle = this.getCommandTitle();
        String other$commandTitle = other.getCommandTitle();
        if (this$commandTitle == null ? other$commandTitle != null : !this$commandTitle.equals(other$commandTitle)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        DatabaseInfo this$databaseInfo = this.getDatabaseInfo();
        DatabaseInfo other$databaseInfo = other.getDatabaseInfo();
        if (this$databaseInfo == null ? other$databaseInfo != null : !this$databaseInfo.equals(other$databaseInfo)) {
            return false;
        }
        RuntimeInfo this$runtimeInfo = this.getRuntimeInfo();
        RuntimeInfo other$runtimeInfo = other.getRuntimeInfo();
        if (this$runtimeInfo == null ? other$runtimeInfo != null : !this$runtimeInfo.equals(other$runtimeInfo)) {
            return false;
        }
        ChecksRunReportOperationInfo this$operationInfo = this.getOperationInfo();
        ChecksRunReportOperationInfo other$operationInfo = other.getOperationInfo();
        if (this$operationInfo == null ? other$operationInfo != null : !((Object)((Object)this$operationInfo)).equals((Object)other$operationInfo)) {
            return false;
        }
        CustomData this$customData = this.getCustomData();
        CustomData other$customData = other.getCustomData();
        if (this$customData == null ? other$customData != null : !this$customData.equals(other$customData)) {
            return false;
        }
        ChangelogChecksRunInfo this$changelogChecksRunInfo = this.getChangelogChecksRunInfo();
        ChangelogChecksRunInfo other$changelogChecksRunInfo = other.getChangelogChecksRunInfo();
        if (this$changelogChecksRunInfo == null ? other$changelogChecksRunInfo != null : !((Object)this$changelogChecksRunInfo).equals(other$changelogChecksRunInfo)) {
            return false;
        }
        DatabaseChecksRunInfo this$databaseChecksRunInfo = this.getDatabaseChecksRunInfo();
        DatabaseChecksRunInfo other$databaseChecksRunInfo = other.getDatabaseChecksRunInfo();
        return !(this$databaseChecksRunInfo == null ? other$databaseChecksRunInfo != null : !((Object)this$databaseChecksRunInfo).equals(other$databaseChecksRunInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChecksRunReportParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $changelogArgValue = this.getChangelogArgValue();
        result = result * 59 + ($changelogArgValue == null ? 43 : $changelogArgValue.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $commandTitle = this.getCommandTitle();
        result = result * 59 + ($commandTitle == null ? 43 : $commandTitle.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        DatabaseInfo $databaseInfo = this.getDatabaseInfo();
        result = result * 59 + ($databaseInfo == null ? 43 : $databaseInfo.hashCode());
        RuntimeInfo $runtimeInfo = this.getRuntimeInfo();
        result = result * 59 + ($runtimeInfo == null ? 43 : $runtimeInfo.hashCode());
        ChecksRunReportOperationInfo $operationInfo = this.getOperationInfo();
        result = result * 59 + ($operationInfo == null ? 43 : ((Object)((Object)$operationInfo)).hashCode());
        CustomData $customData = this.getCustomData();
        result = result * 59 + ($customData == null ? 43 : $customData.hashCode());
        ChangelogChecksRunInfo $changelogChecksRunInfo = this.getChangelogChecksRunInfo();
        result = result * 59 + ($changelogChecksRunInfo == null ? 43 : ((Object)$changelogChecksRunInfo).hashCode());
        DatabaseChecksRunInfo $databaseChecksRunInfo = this.getDatabaseChecksRunInfo();
        result = result * 59 + ($databaseChecksRunInfo == null ? 43 : ((Object)$databaseChecksRunInfo).hashCode());
        return result;
    }

    public String toString() {
        return "ChecksRunReportParameters(changelogArgValue=" + this.getChangelogArgValue() + ", jdbcUrl=" + this.getJdbcUrl() + ", commandTitle=" + this.getCommandTitle() + ", date=" + this.getDate() + ", databaseInfo=" + this.getDatabaseInfo() + ", runtimeInfo=" + this.getRuntimeInfo() + ", operationInfo=" + (Object)((Object)this.getOperationInfo()) + ", customData=" + this.getCustomData() + ", changelogChecksRunInfo=" + this.getChangelogChecksRunInfo() + ", databaseChecksRunInfo=" + this.getDatabaseChecksRunInfo() + ")";
    }
}

