/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.markunused.change;

import com.datical.liquibase.ext.appdba.markunused.change.MarkUnusedStatement;
import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropColumnChange;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="markUnused", description="Marks Column Unused", priority=101)
public class MarkUnusedChange
extends LicenseValidationChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String columnName;

    public MarkUnusedChange() {
    }

    public MarkUnusedChange(DropColumnChange change) {
        this.catalogName = change.getCatalogName();
        this.schemaName = change.getSchemaName();
        this.tableName = change.getTableName();
        this.columnName = change.getColumnName();
    }

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, (Change)this);
    }

    public boolean supports(Database database) {
        return database instanceof OracleDatabase;
    }

    @DatabaseChangeProperty(description="Name of the database catalog")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(description="Name of the database schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(description="Name of the table containing the column to mark as unused")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(description="Name of the column to mark as unused")
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getConfirmationMessage() {
        return "Column " + this.tableName + "." + this.columnName + " marked as unused";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new MarkUnusedStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumnName())};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }
}

