/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import liquibase.util.StringUtil;

public class RegexGetter
extends AbstractCommandLineValueGetter<String> {
    private final boolean allowEmpty;

    public RegexGetter() {
        this(false);
    }

    public RegexGetter(boolean allowEmpty) {
        super(String.class);
        this.allowEmpty = allowEmpty;
    }

    @Override
    public boolean validate(String input) {
        if (this.allowEmpty && StringUtil.isEmpty((String)input)) {
            return true;
        }
        try {
            Pattern.compile(input);
        }
        catch (PatternSyntaxException pe) {
            throw new PatternSyntaxException("The supplied input is not a valid regular expression", pe.getPattern(), pe.getIndex());
        }
        return true;
    }

    @Override
    public String convert(String input) {
        return input;
    }
}

