/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.helpers;

import com.datical.liquibase.ext.command.helpers.VisibleReportCommandArguments;
import com.datical.liquibase.ext.config.ReportConfiguration;
import com.datical.liquibase.ext.reports.ReportArguments;
import com.datical.liquibase.ext.reports.ReportFormat;
import java.util.Collections;
import java.util.List;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.AbstractArgumentCommandStep;

@Deprecated
public class ReportCommandArguments
extends AbstractArgumentCommandStep {
    protected static final String[] COMMAND_NAME = new String[]{"report"};
    public static final CommandArgumentDefinition<String> REPORT_NAME;
    public static final CommandArgumentDefinition<String> REPORT_PATH;
    public static final CommandArgumentDefinition<Boolean> REPORT_ENABLED;
    public static final CommandArgumentDefinition<ReportFormat> REPORT_FORMAT;
    public static final String DEFAULT_REPORT_NAME_DATE_FORMAT = "dd-MMM-yyyy-HHmmss";
    public static final String REPORT_NAME_EXAMPLE;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(ReportArguments.class);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        ReportFormat format;
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Boolean enabled = (Boolean)commandScope.getArgumentValue(REPORT_ENABLED);
        String name = (String)commandScope.getArgumentValue(REPORT_NAME);
        String defaultName = VisibleReportCommandArguments.getDefaultReportName(resultsBuilder.getCommandScope().getCommand().getName());
        String path = (String)commandScope.getArgumentValue(REPORT_PATH);
        ReportArguments arguments = this.handleArgumentHierarchy(enabled, name, path, format = (ReportFormat)((Object)commandScope.getArgumentValue(REPORT_FORMAT)));
        if (arguments.getName().equals(REPORT_NAME_EXAMPLE)) {
            arguments.setName(defaultName);
        }
        commandScope.provideDependency(ReportArguments.class, (Object)arguments);
    }

    private ReportArguments handleArgumentHierarchy(Boolean cmdEnabled, String cmdName, String cmdPath, ReportFormat cmdFormat) {
        Boolean globalEnabled = (Boolean)ReportConfiguration.ENABLED.getCurrentValue();
        String globalName = (String)ReportConfiguration.NAME.getCurrentValue();
        String globalPath = (String)ReportConfiguration.PATH.getCurrentValue();
        ReportFormat globalFormat = (ReportFormat)((Object)ReportConfiguration.FORMAT.getCurrentValue());
        boolean enabledOverride = cmdEnabled != null;
        boolean nameOverride = cmdName != null;
        boolean pathOverride = cmdPath != null;
        boolean formatOverride = cmdFormat != null;
        Boolean enabledSetting = enabledOverride ? cmdEnabled : globalEnabled;
        String nameSetting = nameOverride ? cmdName : globalName;
        String pathSetting = pathOverride ? cmdPath : globalPath;
        ReportFormat formatSetting = formatOverride ? cmdFormat : globalFormat;
        return new ReportArguments(enabledSetting, nameSetting, pathSetting, formatSetting, !nameOverride, !pathOverride, !formatOverride);
    }

    static {
        REPORT_NAME_EXAMPLE = String.format("report-%s", DEFAULT_REPORT_NAME_DATE_FORMAT);
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        REPORT_ENABLED = builder.argument("reportEnabled", Boolean.class).description("Enable or disable reporting.").addAlias("reportsEnabled").hidden().build();
        REPORT_NAME = builder.argument("reportName", String.class).description("The name of the report.").addAlias("reportsName").hidden().build();
        REPORT_PATH = builder.argument("reportPath", String.class).description("The path to the directory to generate the report.").addAlias("reportsPath").hidden().build();
        REPORT_FORMAT = builder.argument("reportFormat", ReportFormat.class).description("The format of the report. Currently, can only be set to \"html\".").addAlias("reportsFormat").hidden().build();
    }
}

