/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.action;

import com.datical.liquibase.ext.flow.condition.Condition;
import com.datical.liquibase.ext.flow.condition.ExceptionThrowingCondition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import liquibase.command.CommandResultsBuilder;
import liquibase.exception.CommandExecutionException;

public abstract class Action {
    private Condition condition;
    public static final String CONDITION_KEY = "if";
    private final Map<String, Object> userMetadata = new HashMap<String, Object>();

    Action() {
        this.condition = new ExceptionThrowingCondition();
    }

    public abstract String getCommand();

    public Map<String, Object> getUserMetadata() {
        return Collections.unmodifiableMap(this.userMetadata);
    }

    public void addUserMetadata(String key, Object value) {
        this.userMetadata.put(key, value);
    }

    public abstract String getType();

    public abstract Action fromAction(Map<String, Object> var1, Map<String, Object> var2);

    public abstract void validate(String var1) throws CommandExecutionException;

    protected void addUserMetadata(Map<String, Object> userMetadata, Action action) {
        if (userMetadata != null) {
            userMetadata.forEach(action::addUserMetadata);
        }
    }

    public abstract void execute(CommandResultsBuilder var1) throws CommandExecutionException;

    public final Condition getCondition() {
        return this.condition;
    }

    public final void setCondition(Map<String, Object> actionMap, Map<String, Object> variables) {
        Object conditionText = actionMap.get(CONDITION_KEY);
        this.condition = conditionText != null ? Condition.fromString(String.valueOf(conditionText), variables) : null;
    }

    public Map<String, Object> getCombinedUserMetadata(Map<String, Object> flowFileUserMetadata, Map<String, Object> stageUserMetadata) {
        HashMap<String, Object> combined = new HashMap<String, Object>();
        if (flowFileUserMetadata != null) {
            combined.putAll(flowFileUserMetadata);
        }
        if (stageUserMetadata != null) {
            combined.putAll(stageUserMetadata);
        }
        combined.putAll(this.userMetadata);
        return combined;
    }
}

