/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.visitor;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import liquibase.ContextExpression;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.util.StringUtil;

public class ModifyChangeSetContextsVisitor
implements ChangeSetVisitor {
    private final String setAsContexts;
    private final boolean forceReplace;

    public ModifyChangeSetContextsVisitor(String setAsContexts, boolean forceReplace) {
        this.setAsContexts = setAsContexts;
        this.forceReplace = forceReplace;
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
        ContextExpression currentValue = new ContextExpression((Collection)changeSet.getContextFilter().getContexts());
        if (this.forceReplace) {
            if (!currentValue.toString().equalsIgnoreCase(this.setAsContexts)) {
                Scope.getCurrentScope().getLog(ModifyChangeSetContextsVisitor.class).info(String.format("Change set %s contexts set to %s", changeSet, this.setAsContexts));
            }
            changeSet.setContextFilter(new ContextExpression(this.setAsContexts));
        } else {
            List newContexts = StringUtil.splitAndTrim((String)this.setAsContexts, (String)",");
            newContexts.forEach(arg_0 -> ((ContextExpression)currentValue).add(arg_0));
            if (!this.prepareContexts(currentValue.toString()).equalsIgnoreCase(changeSet.getContextFilter().toString())) {
                Scope.getCurrentScope().getLog(ModifyChangeSetContextsVisitor.class).info(String.format("Change set %s contexts set to %s", changeSet.toString(), StringUtil.join((Collection)newContexts, (String)",")));
            }
            changeSet.setContextFilter(currentValue);
        }
    }

    private String prepareContexts(String originalString) {
        if (StringUtil.isEmpty((String)originalString)) {
            return originalString;
        }
        return originalString.replace("(", "").replace(")", "");
    }
}

