/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.cli.StringGetter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import liquibase.Scope;
import org.apache.commons.lang3.StringUtils;

public class ArgsStringGetter
extends StringGetter {
    public ArgsStringGetter(boolean allowEmpty) {
        super(allowEmpty);
    }

    @Override
    public boolean validate(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return true;
        }
        boolean b = super.validate(input);
        if (!b) {
            return b;
        }
        AtomicBoolean flag = new AtomicBoolean(true);
        String[] parts = input.split(",");
        Arrays.stream(parts).forEach(part -> {
            String[] kv = part.trim().split("=");
            if (kv.length == 1) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Argument '" + kv[0] + "' has no value");
                flag.set(false);
            }
        });
        return flag.get();
    }
}

