/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.dynamic.AbstractMaxAffectedRows;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;

public class MaxAffectedRowsAllowedDelete
extends AbstractMaxAffectedRows {
    public static final String DELETE_FROM = "delete from";

    @Override
    public String getName() {
        return "Check Affected Rows Count on Delete";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getShortName() {
        return "MaxAffectedRowsAllowedDelete";
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, Database database, DynamicRule dynamicRule) {
        this.database = database;
        return this.doEvaluate(changeSet.getChanges(), changeSet, dynamicRule, DELETE_FROM);
    }

    @Override
    public boolean requiresPendingChanges() {
        return true;
    }

    @Override
    public String getDescription() {
        return "This checks triggers when the Max Affected Rows Allowed value is exceeded by the number of rows DELETED by a SQL statement.  The SQL statement is executed against the database, and then rolled back.";
    }

    @Override
    public int getPriority() {
        return 77;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.MAX_ROWS), new RuleParameter(DynamicRuleParameterEnum.MESSAGE, null, null, "<AFFECTED_ROWS> rows will be affected, which is more than the allowed '<THRESHOLD>' rows. The SQL statement is '<STATEMENT>' in '<CHANGESET>'.", false));
    }
}

