/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksCustomizeCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.command.helpers.ChecksAutoEnableNewChecksArgument;
import com.datical.liquibase.ext.command.helpers.ChecksAutoUpdateArgument;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.LiquibaseException;
import liquibase.util.StringUtil;

public class ChecksCopyCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "copy"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(ChecksAutoUpdateArgument.class, ChecksAutoEnableNewChecksArgument.class);
    }

    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String checksSettingsFile = (String)commandScope.getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        String checkName = (String)commandScope.getConfiguredValue(CHECK_NAME_ARG).getValue();
        List<AbstractLiquibaseRule> rules = ChecksCopyCommandStep.listAllRules();
        Boolean autoUpdate = (Boolean)commandScope.getDependency(ChecksAutoUpdateArgument.class);
        Boolean autoEnableNewChecks = (Boolean)commandScope.getDependency(ChecksAutoEnableNewChecksArgument.class);
        CheckSettingsConfigHelper helper = new CheckSettingsConfigHelper(checksSettingsFile, autoUpdate, autoEnableNewChecks);
        CheckSettingsConfig csc = helper.read(rules);
        this.throwExceptionIfPackageFile(csc);
        if (csc == null) {
            resultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        ChecksCopyCommandStep.doCopy(csc, checkName, rules, resultsBuilder, helper, true);
        csc.outputWarningMessage();
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    public static void doCopy(CheckSettingsConfig csc, String checkName, List<AbstractLiquibaseRule> rules, CommandResultsBuilder resultsBuilder, CheckSettingsConfigHelper helper, boolean printTable) throws LiquibaseException, IOException {
        DynamicRule configurableRule = csc.getDynamicConfigurableRuleByShortName(checkName, "does not have customization options and can't be copied because it would be redundant with the original check");
        AbstractLiquibaseRule configurableParentRule = ChecksCopyCommandStep.findConfigurableParentRule(configurableRule, rules, checkName, "does not have customization options and can't be copied because it would be redundant with the original check");
        if (configurableParentRule.getParameters().isEmpty()) {
            throw new CommandExecutionException("\n\nCheck '" + checkName + "' does not have customization options." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks and customization options for checks.");
        }
        String newDefaultName = ChecksCopyCommandStep.createDefaultName(checkName, csc);
        String newShortName = (String)Scope.getCurrentScope().getUI().prompt("\nGive your check a short name for easier identification (up to 64 alpha-numeric characters only)", (Object)newDefaultName, (input, type) -> {
            if (input == null) {
                throw new IllegalArgumentException();
            }
            String candidate = input;
            boolean isAlphaNumeric = candidate.chars().allMatch(Character::isLetterOrDigit);
            if (!isAlphaNumeric) {
                throw new IllegalArgumentException(String.format("Invalid value: '%s': Only alpha-numeric characters are allowed for a short name", input));
            }
            if (candidate.length() > 64) {
                throw new IllegalArgumentException(String.format("Invalid value: '%s': New check name '%s' exceeds %s characters.  Please try again", input, candidate, 64));
            }
            if (csc.getDynamicRuleByShortName(candidate) != null) {
                throw new IllegalArgumentException(String.format("Invalid value: '%s': A check with the short name '%s' already exists", input, candidate));
            }
            return input;
        }, String.class);
        Scope.getCurrentScope().getUI().sendMessage(String.format("New check '%s' created from '%s'\n", newShortName, checkName));
        DynamicRule newRuleCopy = ChecksCopyCommandStep.createCopyFromOriginal(configurableRule, newShortName, configurableParentRule);
        ChecksCopyCommandStep.modifySeverity(newRuleCopy);
        try {
            Scope.child((String)"checkSettingsConfig", (Object)csc, () -> {
                List<DynamicRuleParameter> newParameterValues = ChecksCustomizeCommandStep.promptForParameters(configurableParentRule.getParameters(), configurableRule);
                newRuleCopy.getParameters().addAll(newParameterValues);
            });
        }
        catch (Exception e) {
            throw new LiquibaseException((Throwable)e);
        }
        csc.getRules().add(newRuleCopy);
        helper.write(csc);
        if (printTable) {
            Scope.getCurrentScope().getUI().sendMessage("Customization complete. Review the table below to confirm your changes.");
            ChecksShowCommandStep.writeTableToOutput(resultsBuilder, csc, false);
        }
    }

    private static String createDefaultName(String checkName, CheckSettingsConfig csc) {
        int num;
        String numString;
        Pattern p = Pattern.compile(".*(\\d+$)");
        Matcher m = p.matcher(checkName);
        if (!m.find()) {
            numString = "1";
            num = 1;
        } else {
            numString = m.group(1);
            checkName = checkName.replaceAll(numString, "");
            num = Integer.parseInt(numString) + 1;
        }
        String candidate = null;
        boolean unique = false;
        while (!unique) {
            candidate = checkName + Integer.valueOf(num).toString();
            DynamicRule configuredRule = csc.getDynamicRuleByShortName(candidate);
            if (configuredRule == null) {
                unique = true;
                continue;
            }
            ++num;
        }
        return candidate;
    }

    private static DynamicRule createCopyFromOriginal(DynamicRule originalRule, String newShortName, AbstractLiquibaseRule configurableParentRule) {
        boolean isEnabled = !configurableParentRule.isEnabledByDefault() || originalRule.isEnabled();
        return new DynamicRule(isEnabled, originalRule.getSeverity(), UUID.nameUUIDFromBytes(StringUtil.getBytesWithEncoding((String)newShortName)), newShortName, originalRule.getName(), originalRule.getDescription(), originalRule.getParentRuleId() != null ? originalRule.getParentRuleId() : originalRule.getId(), new ArrayList<DynamicRuleParameter>(), originalRule.getFileInfo());
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Create a copy of an existing check and provide new customization options for the copy");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = builder.argument("checkName", String.class).required().description("Name of check to configure").build();
        CHECKS_SETTINGS_FILE_ARG = builder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
    }
}

