/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.SetupException;
import liquibase.license.LicenseServiceUtils;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.parser.core.formattedsql.FormattedSqlChangeLogParser;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;

public class ProFormattedSqlChangeLogParser
extends FormattedSqlChangeLogParser {
    protected final String ROLLBACK_SQL_FILE_REGEX = String.format("\\s*%s[\\s]*rollbackSqlFile[\\s]+(.*)", this.getSingleLineCommentSequence());
    protected final Pattern ROLLBACK_SQL_FILE_PATTERN = Pattern.compile(this.ROLLBACK_SQL_FILE_REGEX, 2);
    protected final String INCLUDE_REGEX = String.format("\\s*%s[\\s]*include[\\s]+(.*)", this.getSingleLineCommentSequence());
    protected final Pattern INCLUDE_PATTERN = Pattern.compile(this.INCLUDE_REGEX, 2);
    protected final String INCLUDE_ALL_REGEX = String.format("\\s*%s[\\s]*includeAll[\\s]+(.*)", this.getSingleLineCommentSequence());
    protected final Pattern INCLUDE_ALL_PATTERN = Pattern.compile(this.INCLUDE_ALL_REGEX, 2);
    protected static final String INCLUDE_FILE_REGEX = ".*?file:(\".*?\"|\\S*).*";
    protected final Pattern INCLUDE_FILE_PATTERN = Pattern.compile(".*?file:(\".*?\"|\\S*).*", 2);
    protected static final String INCLUDE_ALL_PATH_REGEX = ".*?path:(\".*?\"|\\S*).*";
    protected final Pattern INCLUDE_ALL_PATH_PATTERN = Pattern.compile(".*?path:(\".*?\"|\\S*).*", 2);
    protected final String IGNORE_CHANGESET_REGEX = String.format("\\s*%s[\\s]*ignore:[\\s]*(.*)", this.getSingleLineCommentSequence());
    protected final Pattern IGNORE_CHANGESET_PATTERN = Pattern.compile(".*ignore:(\\w*).*", 2);
    protected static final String ERROR_IF_MISSING_OR_EMPTY_REGEX = ".*errorIfMissingOrEmpty:(\\w+).*";
    protected final Pattern ERROR_IF_MISSING_OR_EMPTY_PATTERN = Pattern.compile(".*errorIfMissingOrEmpty:(\\w+).*", 2);
    protected static final String ERROR_IF_MISSING_REGEX = ".*errorIfMissing:(\\w+).*";
    protected final Pattern ERROR_IF_MISSING_PATTERN = Pattern.compile(".*errorIfMissing:(\\w+).*", 2);
    protected static final String IS_RELATIVE_PATH_REGEX = ".*relativeToChangelogFile:(\\w+).*";
    protected final Pattern IS_RELATIVE_PATH_PATTERN = Pattern.compile(".*relativeToChangelogFile:(\\w+).*", 2);
    protected static final String PATH_REGEX = ".*path:(\".*?\"|\\S*).*";
    protected final Pattern PATH_PATTERN = Pattern.compile(".*path:(\".*?\"|\\S*).*", 2);
    protected static final String RELATIVE_TO_CHANGELOG_REGEX = ".*relativeToChangelog:(\".*?\"|\\S*).*";
    protected final Pattern RELATIVE_TO_CHANGELOG_PATTERN = Pattern.compile(".*relativeToChangelog:(\".*?\"|\\S*).*", 2);
    protected static final String RESOURCE_FILTER_REGEX = ".*resourceFilter:(\".*?\"|\\S*).*";
    protected final Pattern RESOURCE_FILTER_PATTERN = Pattern.compile(".*resourceFilter:(\".*?\"|\\S*).*", 2);
    protected static final String FILTER_REGEX = ".*\\s+filter:(\".*?\"|\\S*).*";
    protected final Pattern FILTER_PATTERN = Pattern.compile(".*\\s+filter:(\".*?\"|\\S*).*", 2);
    protected static final String ENDS_WITH_FILTER_REGEX = ".*endsWithFilter:(\".*?\"|\\S*).*";
    protected final Pattern ENDS_WITH_FILTER_PATTERN = Pattern.compile(".*endsWithFilter:(\".*?\"|\\S*).*", 2);
    protected static final String MIN_DEPTH_REGEX = ".*minDepth:(\".*?\"|\\S*).*";
    protected final Pattern MIN_DEPTH_PATTERN = Pattern.compile(".*minDepth:(\".*?\"|\\S*).*", 2);
    protected static final String MAX_DEPTH_REGEX = ".*maxDepth:(\".*?\"|\\S*).*";
    protected final Pattern MAX_DEPTH_PATTERN = Pattern.compile(".*maxDepth:(\".*?\"|\\S*).*", 2);
    protected static final String RESOURCE_COMPARATOR_DEF_REGEX = ".*\\s+filter:(\".*?\"|\\S*).*";
    protected final Pattern RESOURCE_COMPARATOR_DEF_PATTERN = Pattern.compile(".*\\s+filter:(\".*?\"|\\S*).*", 2);
    private static final String ENCODING_REGEX = ".*encoding:(\".*?\"|\\S*).*";
    private final Pattern ENCODING_PATTERN = Pattern.compile(".*encoding:(\".*?\"|\\S*).*", 2);

    public int getPriority() {
        return super.getPriority() + 5;
    }

    protected void configureChangeSet(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, BufferedReader reader, StringBuilder currentSequence, StringBuilder currentRollbackSequence, ChangeSet changeSet, int count, String line, Matcher commentMatcher, ResourceAccessor resourceAccessor, DatabaseChangeLog changeLog, AbstractSQLChange change, Matcher rollbackSplitStatementsPatternMatcher, boolean rollbackSplitStatements, String rollbackEndDelimiter, AtomicBoolean changeSetFinished) throws ChangeLogParseException, IOException {
        Matcher rollbackSqlFileMatcher = this.ROLLBACK_SQL_FILE_PATTERN.matcher(line);
        if (this.handleAdditionalLines(changeLog, resourceAccessor, line)) {
            this.handleChangeSet(physicalChangeLogLocation, changeLogParameters, changeSet, currentSequence, change, changeLog, currentRollbackSequence, rollbackSplitStatementsPatternMatcher, rollbackSplitStatements, rollbackEndDelimiter);
            ProFormattedSqlChangeLogParser.resetSequences((StringBuilder)currentSequence, (StringBuilder)currentRollbackSequence);
            changeSetFinished.set(true);
        } else if (rollbackSqlFileMatcher.matches()) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                Scope.getCurrentScope().getUI().sendMessage("ERROR: Using rollback scripts with formatted SQL requires a valid Liquibase Pro key. Get a free license key at https://liquibase.com/trial. Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.");
            } else if (resourceAccessor != null) {
                String rollbackSqlAttributes = rollbackSqlFileMatcher.group(1);
                Matcher m = this.PATH_PATTERN.matcher(rollbackSqlAttributes);
                if (!m.matches()) {
                    String message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--rollbackSqlFile path:<SQL file path> [relativeToChangelog:true|false]", this.getDocumentationLink());
                    throw new ChangeLogParseException("\n" + message);
                }
                String path = DatabaseChangeLog.normalizePath((String)m.group(1));
                boolean isRelativeToChangelog = false;
                m = this.RELATIVE_TO_CHANGELOG_PATTERN.matcher(rollbackSqlAttributes);
                if (m.matches()) {
                    isRelativeToChangelog = Boolean.parseBoolean(m.group(1));
                }
                String encoding = this.handleEncoding(line);
                RawSQLChange rawSQLChange = new RawSQLChange(this.readRollbackSqlFile(path, resourceAccessor, physicalChangeLogLocation, isRelativeToChangelog, encoding));
                this.handleEndDelimiter(line, (AbstractSQLChange)rawSQLChange);
                String dbms = this.handleDbms(changeLogParameters, line, changeSet.getChangeLog());
                rawSQLChange.setDbms(dbms);
                this.handleSplitStatements(line, changeSet, (AbstractSQLChange)rawSQLChange);
                this.handleStripComments(line, changeSet, (AbstractSQLChange)rawSQLChange);
                changeSet.addRollbackChange((Change)rawSQLChange);
            }
        } else {
            super.configureChangeSet(physicalChangeLogLocation, changeLogParameters, reader, currentSequence, currentRollbackSequence, changeSet, count, line, commentMatcher, resourceAccessor, null, null, null, false, null, changeSetFinished);
        }
    }

    protected boolean handleAdditionalLines(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, String line) throws ChangeLogParseException {
        Matcher includeMatcher = this.INCLUDE_PATTERN.matcher(line);
        boolean include = includeMatcher.matches();
        Matcher includeAllMatcher = this.INCLUDE_ALL_PATTERN.matcher(line);
        boolean includeAll = includeAllMatcher.matches();
        if (!include && !includeAll) {
            return false;
        }
        if (!LicenseServiceUtils.isProLicenseValid()) {
            String type = include ? "include" : "includeAll";
            String message = String.format("ERROR: Using %s with formatted SQL requires a valid Liquibase Pro key. Get a free license key at https://liquibase.com/trial. Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.", type);
            throw new ChangeLogParseException(message);
        }
        if (include) {
            return this.include(changeLog, resourceAccessor, includeMatcher);
        }
        return this.includeAll(changeLog, resourceAccessor, includeAllMatcher);
    }

    private boolean include(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, Matcher includeMatcher) throws ChangeLogParseException {
        ParsedNode includeNode = new ParsedNode(null, "include");
        String includeParameters = includeMatcher.group(1);
        this.addNode(includeNode, this.createChildNode("file", this.INCLUDE_FILE_PATTERN.matcher(includeParameters)));
        this.addNode(includeNode, this.createChildNode("contextFilter", this.determineContextMatcher(includeParameters)));
        this.addNode(includeNode, this.createChildNode("labels", this.LABELS_PATTERN.matcher(includeParameters)));
        this.addNode(includeNode, this.createChildNode("ignore", this.IGNORE_CHANGESET_PATTERN.matcher(includeParameters)));
        this.addNode(includeNode, this.createChildNode("errorIfMissing", this.ERROR_IF_MISSING_PATTERN.matcher(includeParameters)));
        this.addNode(includeNode, this.createChildNode("relativeToChangelogFile", this.RELATIVE_TO_CHANGELOG_PATTERN.matcher(includeParameters)));
        try {
            changeLog.handleChildNodeHelper(includeNode, resourceAccessor, new HashMap());
        }
        catch (SetupException | ParsedNodeException e) {
            throw new ChangeLogParseException(e);
        }
        return true;
    }

    private boolean includeAll(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, Matcher includeAllMatcher) throws ChangeLogParseException {
        ParsedNode includeAllNode = new ParsedNode(null, "includeAll");
        String includeParameters = includeAllMatcher.group(1);
        this.addNode(includeAllNode, this.createChildNode("path", this.INCLUDE_ALL_PATH_PATTERN.matcher(includeParameters)));
        this.addNode(includeAllNode, this.createChildNode("relativeToChangelogFile", this.RELATIVE_TO_CHANGELOG_PATTERN.matcher(includeParameters)));
        this.addNode(includeAllNode, this.createChildNode("resourceFilter", this.determineResourceFilterMatcher(includeParameters)));
        this.addNode(includeAllNode, this.createChildNode("errorIfMissingOrEmpty", this.ERROR_IF_MISSING_OR_EMPTY_PATTERN.matcher(includeParameters)));
        this.addNode(includeAllNode, this.createChildNode("resourceComparator", this.RESOURCE_COMPARATOR_DEF_PATTERN.matcher(includeParameters)));
        this.addNode(includeAllNode, this.createChildNode("context", this.determineContextMatcher(includeParameters)));
        this.addNode(includeAllNode, this.createChildNode("labels", this.LABELS_PATTERN.matcher(includeParameters)));
        this.addNode(includeAllNode, this.createChildNode("ignore", this.IGNORE_CHANGESET_PATTERN.matcher(includeParameters)));
        this.addNode(includeAllNode, this.createChildNode("minDepth", this.determineMinDepth(includeParameters)));
        this.addNode(includeAllNode, this.createChildNode("maxDepth", this.determineMaxDepth(includeParameters)));
        this.addNode(includeAllNode, this.createChildNode("endsWithFilter", this.ENDS_WITH_FILTER_PATTERN.matcher(includeParameters)));
        try {
            changeLog.handleChildNodeHelper(includeAllNode, resourceAccessor, new HashMap());
        }
        catch (SetupException | ParsedNodeException e) {
            throw new ChangeLogParseException(e);
        }
        return true;
    }

    private void addNode(ParsedNode parent, ParsedNode child) throws ChangeLogParseException {
        try {
            if (child != null) {
                parent.addChild(child);
            }
        }
        catch (ParsedNodeException pne) {
            throw new ChangeLogParseException((Throwable)pne);
        }
    }

    protected String readRollbackSqlFile(String path, ResourceAccessor resourceAccessor, String physicalChangelogLocation, boolean isRelativeToChangelog, String encoding) throws IOException {
        if (isRelativeToChangelog) {
            path = resourceAccessor.get(physicalChangelogLocation).resolveSibling(path).getPath();
            path = DatabaseChangeLog.normalizePath((String)Paths.get(path, new String[0]).toString());
        }
        try (InputStream inputStream = resourceAccessor.get(path).openInputStream();){
            String string = StreamUtil.readStreamAsString((InputStream)inputStream, (String)encoding);
            return string;
        }
    }

    private String handleEncoding(String line) {
        Matcher encodingPatternMatcher = this.ENCODING_PATTERN.matcher(line);
        return this.parseString(encodingPatternMatcher);
    }

    private String getValueFromMatcher(Matcher matcher) {
        if (matcher != null && matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private ParsedNode createChildNode(String name, Integer intValue) throws ChangeLogParseException {
        try {
            if (intValue != null) {
                ParsedNode parsedNode = new ParsedNode(null, name);
                parsedNode.setValue((Object)intValue);
                return parsedNode;
            }
        }
        catch (ParsedNodeException pne) {
            throw new ChangeLogParseException((Throwable)pne);
        }
        return null;
    }

    private ParsedNode createChildNode(String name, Matcher matcher) throws ChangeLogParseException {
        try {
            String value = this.getValueFromMatcher(matcher);
            if (value != null) {
                ParsedNode parsedNode = new ParsedNode(null, name);
                parsedNode.setValue((Object)value);
                return parsedNode;
            }
        }
        catch (ParsedNodeException pne) {
            throw new ChangeLogParseException((Throwable)pne);
        }
        return null;
    }

    private Integer determineMaxDepth(String line) throws ChangeLogParseException {
        Integer maxDepth = null;
        Matcher maxDepthMatcher = this.MAX_DEPTH_PATTERN.matcher(line);
        if (maxDepthMatcher.matches()) {
            String maxDepthString = maxDepthMatcher.group(1);
            try {
                maxDepth = Integer.parseInt(maxDepthString);
                if (maxDepth < 0) {
                    throw new ChangeLogParseException("Illegal max depth value of '" + maxDepthString + "'.  The value must be > 0.");
                }
            }
            catch (NumberFormatException nfe) {
                throw new ChangeLogParseException("Invalid max depth value of '" + maxDepthString + "'.  The value must be a valid integer < MAX_VALUE");
            }
        }
        return maxDepth;
    }

    private Integer determineMinDepth(String line) throws ChangeLogParseException {
        Integer minDepth = null;
        Matcher minDepthMatcher = this.MIN_DEPTH_PATTERN.matcher(line);
        if (minDepthMatcher.matches()) {
            String minDepthString = minDepthMatcher.group(1);
            try {
                minDepth = Integer.parseInt(minDepthString);
                if (minDepth < 0) {
                    throw new ChangeLogParseException("Illegal min depth value of '" + minDepthString + "'.  The value must be > 0.");
                }
            }
            catch (NumberFormatException nfe) {
                throw new ChangeLogParseException("Invalid min depth value of '" + minDepthString + "'.  The value must be a valid integer > 0");
            }
        }
        return minDepth;
    }

    private Matcher determineResourceFilterMatcher(String line) {
        Matcher resourceFilterMatcher = this.FILTER_PATTERN.matcher(line);
        if (resourceFilterMatcher.matches()) {
            return resourceFilterMatcher;
        }
        Matcher filterDefMatcher = this.RESOURCE_FILTER_PATTERN.matcher(line);
        if (filterDefMatcher.matches()) {
            return filterDefMatcher;
        }
        return null;
    }

    private Matcher determineContextMatcher(String line) {
        Matcher contextFilterPatternMatcher = this.CONTEXT_FILTER_PATTERN.matcher(line);
        if (contextFilterPatternMatcher.matches()) {
            return contextFilterPatternMatcher;
        }
        Matcher contextPatternMatcher = this.CONTEXT_PATTERN.matcher(line);
        if (contextPatternMatcher.matches()) {
            return contextPatternMatcher;
        }
        return null;
    }
}

