/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.resource;

import java.io.IOException;
import java.io.OutputStream;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.AbstractPathHandler;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;

public class S3PathHandlerJarExistenceCheck
extends AbstractPathHandler {
    public static final String AWS_INVALID_CREDENTIALS_ERROR_MESSAGE = "The AWS S3 extension JAR was found on the classpath, but there is a configuration issue. Please set your default AWS Region, and any other ACCESS or SECRET keys as described in the AWS documentation.";

    public int getPriority(String root) {
        if (root != null && root.toLowerCase().startsWith("s3://")) {
            try {
                Class.forName("liquibase.resource.s3.S3PathHandler");
            }
            catch (ClassNotFoundException cnfe) {
                throw new UnexpectedLiquibaseException("The AWS s3 extension JAR is not available on the classpath");
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new UnexpectedLiquibaseException(AWS_INVALID_CREDENTIALS_ERROR_MESSAGE);
            }
        }
        return -1;
    }

    public ResourceAccessor getResourceAccessor(String root) throws IOException {
        throw new UnexpectedLiquibaseException("ProPathHandler.getResourceAccessor is not implemented");
    }

    public Resource getResource(String path) throws IOException {
        throw new UnexpectedLiquibaseException("ProPathHandler.getResource is not implemented");
    }

    public OutputStream createResource(String path) throws IOException {
        throw new UnexpectedLiquibaseException("ProPathHandler.createResource is not implemented");
    }
}

