/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.obfuscate.processor;

import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import net.java.truelicense.obfuscate.Obfuscate;
import net.java.truelicense.obfuscate.ObfuscatedString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"net.java.truelicense.obfuscate.Obfuscate"})
@SupportedOptions(value={"net.java.truelicense.obfuscate.verbose", "net.java.truelicense.obfuscate.processor.verbose"})
public class ObfuscateProcessor
extends AbstractProcessor {
    private boolean verbose;
    static final /* synthetic */ boolean $assertionsDisabled;

    @Override
    public void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        Set<String> set = this.getSupportedOptions();
        Map<String, String> map = processingEnvironment.getOptions();
        this.verbose = false;
        for (String string : set) {
            this.verbose |= Boolean.parseBoolean(map.get(string));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.errorRaised() || roundEnvironment.processingOver()) {
            return true;
        }
        for (TypeElement typeElement : set) {
            if (!$assertionsDisabled && !typeElement.asType().toString().equals(Obfuscate.class.getName())) {
                throw new AssertionError();
            }
            for (Element element : roundEnvironment.getElementsAnnotatedWith(typeElement)) {
                VariableElement variableElement = (VariableElement)element;
                TypeElement typeElement2 = (TypeElement)variableElement.getEnclosingElement();
                try {
                    String string = (String)variableElement.getConstantValue();
                    if (ObfuscateProcessor.keepField(variableElement)) {
                        this.warn(ObfuscateProcessor._string#0(), variableElement);
                    }
                    this.debug(ObfuscatedString.obfuscate(string), variableElement);
                }
                catch (RuntimeException runtimeException) {
                    this.error(ObfuscateProcessor._string#1(), variableElement);
                }
            }
        }
        return true;
    }

    private static boolean keepField(Element element) {
        Set<Modifier> set = element.getModifiers();
        return set.contains((Object)Modifier.PROTECTED) || set.contains((Object)Modifier.PUBLIC) || !set.contains((Object)Modifier.STATIC);
    }

    private void debug(CharSequence charSequence, Element element) {
        if (this.verbose) {
            this.getMessager().printMessage(Diagnostic.Kind.NOTE, charSequence, element);
        }
    }

    private void warn(CharSequence charSequence, Element element) {
        this.getMessager().printMessage(Diagnostic.Kind.WARNING, charSequence, element);
    }

    private void error(CharSequence charSequence, Element element) {
        this.getMessager().printMessage(Diagnostic.Kind.ERROR, charSequence, element);
    }

    private Messager getMessager() {
        return this.processingEnv.getMessager();
    }

    static {
        ObfuscateProcessor.$assertionsDisabled = !ObfuscateProcessor.class.desiredAssertionStatus();
    }

    private static /* synthetic */ String _string#0() {
        return new ObfuscatedString(new long[]{466945259084179431L, 6980468846343515787L, 7138055827014639303L, 6557289033384617353L, -6509484887270511568L, -6741456826627068032L, -7051218591217371972L, -1868522079812621352L, 215148107872130440L, -5637162210907338085L, -7294902401415732934L, -6629954231418075278L, -4417486780899136898L, -1813938883915088023L, -4219915272723596432L, 1065139197357413696L}).toString();
    }

    private static /* synthetic */ String _string#1() {
        return new ObfuscatedString(new long[]{4879513722233120574L, -5273270375476295028L, 3349639638731161200L, -4032007523306865249L, 5612046318794973554L, -5711874551812023983L, 3109702054207338748L, -4039175844706748825L}).toString();
    }
}

