/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym.change;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymStatement;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;

public class DropSynonymGenerator
extends AbstractSqlGenerator<DropSynonymStatement> {
    public boolean supports(DropSynonymStatement statement, Database database) {
        return (database instanceof OracleDatabase || database instanceof AbstractDb2Database || database instanceof MSSQLDatabase || database instanceof EnterpriseDBDatabase) && super.supports((SqlStatement)statement, database);
    }

    public ValidationErrors validate(DropSynonymStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("synonymName", (Object)statement.getSynonymName());
        validationErrors.checkDisallowedField("synonymCatalogName", (Object)statement.getSynonymCatalogName(), database, new Class[]{MSSQLDatabase.class});
        if (!(statement.isPrivate() != null && statement.isPrivate().booleanValue() || database instanceof MSSQLDatabase || statement.getSynonymCatalogName() == null && statement.getSynonymSchemaName() == null)) {
            validationErrors.addError("Cannot specify schema name for non-private synonyms");
        }
        if (database instanceof DB2Database) {
            validationErrors.checkRequiredField("objectType", (Object)statement.getObjectType());
        }
        return validationErrors;
    }

    public Warnings warn(DropSynonymStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Warnings warn = super.warn((SqlStatement)statement, database, sqlGeneratorChain);
        if (database instanceof MSSQLDatabase && statement.isPrivate() != null && statement.isPrivate().booleanValue()) {
            warn.addWarning("MSSQL does not support public synonyms. Dropping private synonym " + statement.getSynonymName());
        }
        return warn;
    }

    public Sql[] generateSql(DropSynonymStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String fullSynonymName = database instanceof MSSQLDatabase ? database.escapeObjectName(null, statement.getSynonymSchemaName(), statement.getSynonymName(), Synonym.class) : (statement.isPrivate() == null || statement.isPrivate() == false ? database.escapeObjectName(statement.getSynonymName(), Synonym.class) : database.escapeObjectName(statement.getSynonymCatalogName(), statement.getSynonymSchemaName(), statement.getSynonymName(), Synonym.class));
        StringBuilder sql = new StringBuilder("DROP ");
        if (!(!(database instanceof OracleDatabase) && !(database instanceof AbstractDb2Database) || statement.isPrivate() != null && statement.isPrivate().booleanValue())) {
            sql.append("PUBLIC ");
        }
        if (database instanceof AbstractDb2Database) {
            sql.append("ALIAS ");
        } else {
            sql.append("SYNONYM ");
        }
        sql.append(fullSynonymName);
        ArrayList<UnparsedSql> generatedSql = new ArrayList<UnparsedSql>();
        generatedSql.add(new UnparsedSql(sql.toString(), new DatabaseObject[0]));
        Sql[] finalGeneratedSql = new Sql[generatedSql.size()];
        return generatedSql.toArray(finalGeneratedSql);
    }
}

