/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import com.datical.liquibase.ext.command.helpers.ReportCommandArguments;
import com.datical.liquibase.ext.reports.ReportFormat;
import com.datical.liquibase.ext.util.ProStringUtil;
import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;

public class ReportConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<Boolean> ENABLED;
    public static final ConfigurationDefinition<ReportFormat> FORMAT;
    public static final ConfigurationDefinition<String> NAME;
    public static final ConfigurationDefinition<String> PATH;
    public static final ConfigurationDefinition<Boolean> OPEN;
    public static final ConfigurationDefinition<Boolean> QUIET;

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase");
        ENABLED = builder.define("reports.enabled", Boolean.class).setDescription(ProStringUtil.markWithPro("Enable or disable reporting.")).addAliasKey("liquibase.report.enabled").setDefaultValue((Object)Boolean.TRUE).build();
        FORMAT = builder.define("reports.format", ReportFormat.class).setDescription(ProStringUtil.markWithPro("The format of the report. Currently, can only be set to \"html\".")).addAliasKey("liquibase.report.format").setDefaultValue((Object)ReportFormat.HTML).setHidden(true).build();
        NAME = builder.define("reports.name", String.class).setDescription(ProStringUtil.markWithPro("The name of the reports.")).addAliasKey("liquibase.report.name").setDefaultValue((Object)ReportCommandArguments.REPORT_NAME_EXAMPLE).build();
        PATH = builder.define("reports.path", String.class).setDescription(ProStringUtil.markWithPro("The path to the directory to generate the reports.")).addAliasKey("liquibase.report.path").setDefaultValue((Object)".").build();
        OPEN = builder.define("reports.open", Boolean.class).setDescription(ProStringUtil.markWithPro("Open the newly generated report in your default browser.")).setDefaultValue((Object)true).build();
        QUIET = builder.define("reports.quiet", Boolean.class).setDescription(ProStringUtil.markWithPro("Minimize the amount of logging when generating reports.")).addAliasKey("liquibase.report.quiet").setDefaultValue((Object)false).setHidden(true).build();
    }

    public static class ConfigurationKeys {
        public static final String BASE = "liquibase";
        public static final String REPORT_FORMAT = "reports.format";
        public static final String REPORT_NAME = "reports.name";
        public static final String REPORT_PATH = "reports.path";
        public static final String REPORT_ENABLED = "reports.enabled";
        public static final String REPORT_OPEN = "reports.open";
        public static final String QUIET = "reports.quiet";

        public static String getFullKey(String keyName) {
            return "liquibase." + keyName;
        }
    }
}

