/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.diff.FormattedChangeObject;
import com.datical.liquibase.ext.diff.FormattedDiffDatabase;
import com.datical.liquibase.ext.diff.FormattedDiffDatabases;
import com.datical.liquibase.ext.diff.FormattedDiffModel;
import com.datical.liquibase.ext.diff.FormattedDiffObject;
import com.datical.liquibase.ext.diff.FormattedDiffSerializer;
import com.datical.liquibase.ext.diff.FormattedDifference;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.DiffCommandStep;
import liquibase.database.Database;
import liquibase.diff.DiffResult;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.StringDiff;
import liquibase.exception.CommandValidationException;
import liquibase.license.LicenseServiceUtils;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.util.HelpUtil;

public class InternalFormattedDiffCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"internalFormattedDiff"};
    public static final CommandArgumentDefinition<String> FORMAT_ARG;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        HelpUtil.hideCommandNameInHelpView((CommandDefinition)commandDefinition);
    }

    public int getOrder(CommandDefinition commandDefinition) {
        int result = super.getOrder(commandDefinition);
        if (result < 0 && !commandDefinition.getName()[0].equals(DiffCommandStep.COMMAND_NAME[0])) {
            return result;
        }
        return 1100;
    }

    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(FormattedDiffModel.class);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        boolean isJsonFormat = DiffFormat.JSON.name().equalsIgnoreCase((String)commandScope.getArgumentValue(FORMAT_ARG));
        if (!isJsonFormat) {
            return;
        }
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])DiffCommandStep.COMMAND_NAME);
        DiffResult diffResult = (DiffResult)resultsBuilder.getResult(DiffCommandStep.DIFF_RESULT.getName());
        FormattedDiffModel model = InternalFormattedDiffCommandStep.buildFormattedDiffModel(diffResult);
        resultsBuilder.getOutputStream().write(InternalFormattedDiffCommandStep.serialize(model).getBytes());
        commandScope.provideDependency(FormattedDiffModel.class, (Object)model);
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    public void validate(CommandScope commandScope) throws CommandValidationException {
        boolean found = InternalFormattedDiffCommandStep.validateDiffFormat((String)commandScope.getArgumentValue(FORMAT_ARG));
        if (!found) {
            String messageString = "\nWARNING: The diff command optional Pro parameter '--format' currently supports only 'TXT' or 'JSON' as values.  (Blank defaults to 'TXT')";
            throw new IllegalArgumentException(messageString);
        }
    }

    private static boolean validateDiffFormat(String formatString) {
        return Arrays.stream(DiffFormat.values()).anyMatch(formatElement -> formatElement.toString().equalsIgnoreCase(formatString));
    }

    public static FormattedDiffModel buildFormattedDiffModel(DiffResult diffResult) {
        FormattedDiffObject formattedDiffObject;
        Database targetDatabase = diffResult.getComparisonSnapshot().getDatabase();
        Database referenceDatabase = diffResult.getReferenceSnapshot().getDatabase();
        String targetUrl = targetDatabase.getConnection().getURL();
        String targetName = targetDatabase.getDatabaseProductName();
        StringDiff versionDiff = diffResult.getProductVersionDiff();
        String targetVersion = versionDiff.getTargetVersion();
        String referenceUrl = referenceDatabase.getConnection().getURL();
        String referenceName = referenceDatabase.getDatabaseProductName();
        String referenceVersion = versionDiff.getReferenceVersion();
        FormattedDiffModel formattedDiffModel = new FormattedDiffModel();
        formattedDiffModel.created = new Date().toString();
        formattedDiffModel.databases = new FormattedDiffDatabases();
        formattedDiffModel.databases.reference = new FormattedDiffDatabase();
        formattedDiffModel.databases.reference.name = referenceName;
        formattedDiffModel.databases.reference.majorVersion = "";
        if (referenceVersion != null) {
            InternalFormattedDiffCommandStep.assignVersionInfo(referenceVersion, "reference", formattedDiffModel);
        }
        formattedDiffModel.databases.reference.url = referenceUrl;
        formattedDiffModel.databases.target = new FormattedDiffDatabase();
        formattedDiffModel.databases.target.name = targetName;
        formattedDiffModel.databases.target.majorVersion = "";
        formattedDiffModel.databases.target.minorVersion = "";
        if (targetVersion != null) {
            InternalFormattedDiffCommandStep.assignVersionInfo(referenceVersion, "target", formattedDiffModel);
        }
        formattedDiffModel.databases.target.url = targetUrl;
        for (DatabaseObject databaseObject : diffResult.getMissingObjects()) {
            formattedDiffObject = new FormattedDiffObject(databaseObject, "missingObject");
            formattedDiffModel.missingObjects.add(formattedDiffObject);
        }
        for (DatabaseObject databaseObject : diffResult.getUnexpectedObjects()) {
            formattedDiffObject = new FormattedDiffObject(databaseObject, "unexpectedObject");
            formattedDiffModel.unexpectedObjects.add(formattedDiffObject);
        }
        Set keys = diffResult.getChangedObjects().keySet();
        for (DatabaseObject key : keys) {
            ObjectDifferences objectDifferences = (ObjectDifferences)diffResult.getChangedObjects().get(key);
            Set differences = objectDifferences.getDifferences();
            DatabaseSnapshot targetSnapshot = diffResult.getComparisonSnapshot();
            DatabaseObject databaseObject = targetSnapshot.get(key);
            FormattedDiffObject formattedDiffObject2 = new FormattedDiffObject(databaseObject, "");
            FormattedChangeObject formattedChangeObject = new FormattedChangeObject(formattedDiffObject2);
            List formattedDifferences = differences.stream().map(FormattedDifference::fromDifference).collect(Collectors.toList());
            formattedChangeObject.differences.addAll(formattedDifferences);
            formattedDiffModel.changedObjects.add(formattedChangeObject);
        }
        return formattedDiffModel;
    }

    public static String serialize(FormattedDiffModel model) {
        String output = new FormattedDiffSerializer().serialize((LiquibaseSerializable)model, true);
        output = output.replaceAll("!!com.datical.liquibase.[^\\s]+ (.*)", "$1");
        return output;
    }

    private static String[] assignVersionInfo(String versionToSplit, String referenceOrTarget, FormattedDiffModel formattedDiffModel) {
        String minorVersion;
        if (versionToSplit == null) {
            return new String[0];
        }
        String[] parts = versionToSplit.split("\\.");
        String majorVersion = parts[0];
        String string = minorVersion = parts.length > 1 ? parts[1] : "";
        if (referenceOrTarget.equals("reference")) {
            formattedDiffModel.databases.reference.majorVersion = majorVersion;
            formattedDiffModel.databases.reference.minorVersion = minorVersion;
        } else {
            formattedDiffModel.databases.target.majorVersion = majorVersion;
            formattedDiffModel.databases.target.minorVersion = minorVersion;
        }
        return parts;
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        FORMAT_ARG = builder.argument("format", String.class).defaultValue((Object)DiffFormat.TXT.name()).description(ProStringUtil.markWithPro("Option to create JSON output")).build();
    }

    public static enum DiffFormat {
        JSON,
        TXT,
        NONE;

    }
}

