/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import liquibase.Scope;
import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.CommandValidationException;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.pro.LicenseTier;
import liquibase.util.StringUtil;

public class LiquibaseLabsConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<String> LICENSE_KEY;
    public static final ConfigurationDefinition<String> LICENSE_PRO_LICENSE_KEY;
    private static final String BASE_INVALID_LICENSE_MESSAGE;

    public static boolean isLabsLicenseValid() {
        LicenseServiceFactory licenseServiceFactory = (LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class);
        if (licenseServiceFactory == null) {
            return false;
        }
        LicenseService licenseService = licenseServiceFactory.getLicenseService();
        if (licenseService == null) {
            return false;
        }
        return licenseService.licenseIsValid("Liquibase Labs");
    }

    public static void checkLabsLicenseAndThrowException(String[] commandNames) throws CommandValidationException {
        if (!LiquibaseLabsConfiguration.isLabsLicenseValid()) {
            throw new CommandValidationException(String.format(BASE_INVALID_LICENSE_MESSAGE + " Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.", StringUtil.join((String[])commandNames, (String)" ")));
        }
    }

    public static ConfiguredValue<String> getLicenseKey() {
        if (LICENSE_KEY.getCurrentConfiguredValue().found()) {
            return LICENSE_KEY.getCurrentConfiguredValue();
        }
        if (LICENSE_PRO_LICENSE_KEY.getCurrentConfiguredValue().found()) {
            return LICENSE_PRO_LICENSE_KEY.getCurrentConfiguredValue();
        }
        return null;
    }

    static {
        BASE_INVALID_LICENSE_MESSAGE = "Using '%s' requires a valid " + LicenseTier.LABS.getSubject() + " license. Get a free license key at " + "https://liquibase.com/trial" + ".";
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase");
        LICENSE_KEY = builder.define("licenseKey", String.class).setDescription(LicenseTier.PRO.getSubject() + " or " + LicenseTier.LABS.getSubject() + " license key used to unlock paid capabilities. Get a free trial at \n" + "https://liquibase.com/trial" + " and use in CLI or add liquibase.licenseKey=<yourKey> into your defaults file.").setValueObfuscator(value -> value == null ? null : "license starting with " + value.substring(0, Math.min(value.length(), 10))).build();
        LICENSE_PRO_LICENSE_KEY = builder.define("pro.licenseKey", String.class).setDescription("DEPRECATED: Liquibase Pro license key used to unlock paid capabilities. Get a free trial at\n https://www.liquibase.com/protrial and use in CLI or add liquibase.pro.licenseKey=<yourKey> into your defaults file.").setValueObfuscator(value -> value == null ? null : "license starting with " + value.substring(0, Math.min(value.length(), 10))).build();
    }
}

