/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import com.datical.liquibase.ext.config.ReportConfiguration;
import com.datical.liquibase.ext.reports.ReportType;
import com.datical.liquibase.ext.reports.ReportUtils;
import com.datical.liquibase.ext.reports.ReportWriter;
import com.datical.liquibase.ext.util.EnvironmentUtils;
import com.datical.liquibase.ext.util.ProStringUtil;
import com.datical.liquibase.ext.util.ResourceUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import org.apache.commons.lang3.SystemUtils;

public class FileSystemReportWriter
implements ReportWriter {
    /*
     * Unable to fully structure code
     */
    @Override
    public void open(String path) {
        if (Boolean.TRUE.equals(GlobalConfiguration.HEADLESS.getCurrentValue())) {
            Scope.getCurrentScope().getLog(ReportUtils.class).info("Not opening report, headless is set");
            return;
        }
        try {
            v0 = desktop = Desktop.isDesktopSupported() != false ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.OPEN)) {
                if (SystemUtils.IS_OS_LINUX) {
                    stream = Runtime.getRuntime().exec(new String[]{"which", "xdg-open"}).getInputStream();
                    var4_5 = null;
                    try {
                        if (stream.read() == -1) ** GOTO lbl30
                        Runtime.getRuntime().exec(new String[]{"xdg-open", path});
                    }
                    catch (Throwable var5_7) {
                        var4_5 = var5_7;
                        throw var5_7;
                    }
                    finally {
                        if (stream != null) {
                            if (var4_5 != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable var5_6) {
                                    var4_5.addSuppressed(var5_6);
                                }
                            } else {
                                stream.close();
                            }
                        }
                    }
                } else {
                    desktop.open(new File(path));
                }
lbl30:
                // 3 sources

                Scope.getCurrentScope().getLog(ReportUtils.class).fine("Opened report in browser: " + path);
            }
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(ReportUtils.class).warning("Could not open report in browser!", (Throwable)e);
        }
    }

    @Override
    public void write(String path, String name, String contents, ReportType reportType) throws IOException {
        String maybeRelativePath = FileSystemReportWriter.getPathWithSuffix(path, name);
        boolean resourceCreated = !ResourceUtil.getResource(maybeRelativePath).exists();
        try (OutputStream outputStream = this.createResourceIfNeeded(maybeRelativePath);){
            outputStream.write(contents.getBytes((String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
        }
        String fullyQualifiedPath = ProStringUtil.stripUriPrefix(ResourceUtil.getResource(maybeRelativePath).getUri());
        this.logReportCreated(resourceCreated, fullyQualifiedPath);
    }

    private OutputStream createResourceIfNeeded(String path) throws IOException {
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        return pathHandlerFactory.openResourceOutputStream(path, new OpenOptions().setTruncate(true).setCreateIfNeeded(true));
    }

    public static String getPathWithSuffix(String reportPath, String name) {
        if (reportPath.endsWith("/")) {
            reportPath = reportPath.substring(0, reportPath.length() - 1);
        }
        if (reportPath.toLowerCase().endsWith(".html")) {
            return reportPath;
        }
        String fullPath = name.toLowerCase().endsWith(".html") ? String.format("%s/%s", reportPath, name) : String.format("%s/%s.%s", reportPath, name, "html");
        return fullPath;
    }

    private void logReportCreated(boolean resourceCreated, String fullyQualifiedPath) {
        if (Boolean.TRUE.equals(ReportConfiguration.QUIET.getCurrentValue())) {
            Scope.getCurrentScope().getUI().sendMessage(String.format("A report was generated at: %s", fullyQualifiedPath));
            return;
        }
        String messageTemplate = "Pro %s Report %s!\n* File '%s' was %s.\n** To suppress %s reports add command arg 'liquibase %s --report-enabled=false'\n** To suppress all Pro Reports set liquibase.reports.enabled=false, or LIQUIBASE_REPORTS_ENABLED=false";
        String commandName = EnvironmentUtils.findCommandName();
        String cliCommandName = ProStringUtil.buildCLICommandName(EnvironmentUtils.findCommandName());
        String message = resourceCreated ? String.format(messageTemplate, commandName, "created", fullyQualifiedPath, "created", commandName, cliCommandName) : String.format(messageTemplate, commandName, "updated", fullyQualifiedPath, "updated", commandName, cliCommandName);
        Scope.getCurrentScope().getLog(this.getClass()).info(message);
        Scope.getCurrentScope().getUI().sendMessage(message);
    }
}

