/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic;

import java.util.Set;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.parser.LiquibaseSqlParser;
import liquibase.parser.SqlParserFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.util.StringClauses;

public class StoredLogicComparator
implements DatabaseObjectComparator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (StoredDatabaseLogic.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    public boolean isSameObject(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DatabaseObjectComparatorChain chain) {
        return chain.isSameObject(databaseObject1, databaseObject2, accordingTo);
    }

    public String[] hash(DatabaseObject databaseObject, Database accordingTo, DatabaseObjectComparatorChain chain) {
        return chain.hash(databaseObject, accordingTo);
    }

    public ObjectDifferences findDifferences(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, CompareControl compareControl, DatabaseObjectComparatorChain chain, Set<String> exclude) {
        exclude.add("tableSchema");
        exclude.add("body");
        ObjectDifferences differences = chain.findDifferences(databaseObject1, databaseObject2, accordingTo, compareControl, exclude);
        SqlParserFactory sqlParserFactory = (SqlParserFactory)Scope.getCurrentScope().getSingleton(SqlParserFactory.class);
        LiquibaseSqlParser sqlParser = sqlParserFactory.getSqlParser();
        String body1 = sqlParser.parse(((StoredDatabaseLogic)databaseObject1).getBody(), false, true).toString();
        String body2 = sqlParser.parse(((StoredDatabaseLogic)databaseObject2).getBody(), false, true).toString();
        if (!body1.equals(body2)) {
            differences.addDifference("body", (Object)((StoredDatabaseLogic)databaseObject1).getBody(), (Object)((StoredDatabaseLogic)databaseObject2).getBody());
        }
        if (differences.isDifferent("body") && this.standardize(databaseObject1.getName(), body1, accordingTo).equals(this.standardize(databaseObject2.getName(), body2, accordingTo))) {
            differences.removeDifference("body");
        }
        return differences;
    }

    protected String standardize(String name, String body, Database accordingTo) {
        String newBody;
        name = name.toLowerCase();
        boolean trigger = false;
        SqlParserFactory sqlParserFactory = (SqlParserFactory)Scope.getCurrentScope().getSingleton(SqlParserFactory.class);
        LiquibaseSqlParser sqlParser = sqlParserFactory.getSqlParser();
        StringClauses parsedBody = sqlParser.parse(body);
        StringClauses.ClauseIterator clauseIterator = parsedBody.getClauseIterator();
        while (clauseIterator.hasNext()) {
            Object o = clauseIterator.nextNonWhitespace();
            if (o != null) {
                if ("trigger".equalsIgnoreCase((String)o)) {
                    trigger = true;
                } else {
                    if ("(".equals(o)) break;
                    if (o.toString().toLowerCase().contains(name)) {
                        clauseIterator.remove();
                        break;
                    }
                }
            }
            clauseIterator.remove();
        }
        if (trigger && clauseIterator.hasNext()) {
            boolean removedTable = false;
            Object o = clauseIterator.nextNonWhitespace();
            while (!removedTable && clauseIterator.hasNext()) {
                if ("on".equalsIgnoreCase((String)o)) {
                    o = clauseIterator.nextNonWhitespace();
                    clauseIterator.remove();
                    removedTable = true;
                    continue;
                }
                o = clauseIterator.nextNonWhitespace();
            }
        }
        if (parsedBody.isEmpty()) {
            newBody = body.replaceFirst("(?i)^\\s*create\\s+(\\w+)\\s+", "");
            if (!newBody.equals(body)) {
                return newBody;
            }
            newBody = body.replaceFirst("(?i)^\\s*alter\\s+(\\w+)\\s+", "");
        } else {
            newBody = parsedBody.toString();
        }
        newBody = newBody.replaceFirst("[\\s\\n\\r]*;[\\s\\n\\r]*$", "");
        newBody = newBody.replaceFirst("[\\s\\n\\r]+GO[\\s\\n\\r]*$", "");
        newBody = newBody.replaceFirst("[\\s\\n\\r]+/[\\s\\n\\r]*$", "");
        if (accordingTo instanceof MSSQLDatabase) {
            newBody = newBody.replaceAll("\\[(\\w*?)\\]", "$1");
        }
        return newBody;
    }
}

