/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.config.PsqlConfiguration;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import com.datical.liquibase.ext.tools.NativeExecutorRunner;
import com.datical.liquibase.ext.tools.NativeToolFileCreator;
import com.datical.liquibase.ext.util.NativeRunnerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.Logger;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.structure.core.Schema;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class PsqlRunner
extends NativeExecutorRunner {
    private File outFile = null;
    private Boolean keepTempFile = false;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private String logFile;
    private Integer timeout;
    private File psqlExec;
    private static final String EXECUTABLE_NAME = "psql";

    public PsqlRunner() {
    }

    @Override
    public String getIntegrationDisplayName() {
        return EXECUTABLE_NAME;
    }

    public PsqlRunner(ChangeSet changeSet, Sql[] sqlStrings) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlStrings;
        this.setTimeout("1800");
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    protected List<String> createFinalCommandArray(Database database) {
        this.loadPsqlProperties();
        List commandArray = super.createFinalCommandArray(database);
        try {
            this.writeSqlStrings(database);
        }
        catch (Exception ioe) {
            throw new UnexpectedLiquibaseException((Throwable)ioe);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = (Boolean)PsqlConfiguration.TEMP_KEEP.getCurrentValue();
        }
        if (!this.args.isEmpty()) {
            commandArray.addAll(Collections.unmodifiableList(this.args));
        }
        String connectionString = this.buildConnectionString(database);
        commandArray.add("--dbname");
        commandArray.add(connectionString);
        commandArray.add("-v");
        commandArray.add("ON_ERROR_STOP=1");
        if (this.outFile != null) {
            commandArray.add("--file");
            commandArray.add(this.outFile.getAbsolutePath());
        } else {
            commandArray.add("--version");
        }
        String commandLine = StringUtil.join((Collection)commandArray, (String)" ");
        String hideUserPass = String.format("%s:%s", this.getUserName(database.getConnection()), this.getPassword(database.getConnection()));
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("psql command:\n" + commandLine.replaceAll(hideUserPass, "*****:*****"));
        return commandArray;
    }

    protected void processResult(int returnCode, String errorStreamOut, String infoStreamOut, Database database) {
        boolean hasErrorOut;
        boolean hasInfoOut = infoStreamOut != null && !infoStreamOut.isEmpty();
        boolean bl = hasErrorOut = errorStreamOut != null && !errorStreamOut.isEmpty();
        if (this.logFile != null && this.outFile != null) {
            try {
                Path logFilePath;
                Path path = logFilePath = this.tempPath == null ? Paths.get(this.logFile, new String[0]) : Paths.get(this.tempPath, this.logFile);
                if ((hasInfoOut || hasErrorOut) && logFilePath.getParent() != null) {
                    Files.createDirectories(logFilePath.getParent(), new FileAttribute[0]);
                }
                if (hasInfoOut) {
                    Files.write(logFilePath, infoStreamOut.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
                if (hasErrorOut) {
                    Files.write(logFilePath, errorStreamOut.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
            }
            catch (IOException writeException) {
                String writeExceptionMessage = "Exception thrown when writing log file! Check that your liquibase.psql.logFile and liquibase.psql.keep.temp.path create a valid filepath.";
                throw new UnexpectedLiquibaseException(writeExceptionMessage, (Throwable)writeException);
            }
        }
        if (returnCode != 0 && hasInfoOut) {
            String returnString = this.getCommandString() + " returned a code of " + returnCode + "\n" + infoStreamOut;
            throw new UnexpectedLiquibaseException(returnString);
        }
        super.processResult(returnCode, errorStreamOut, infoStreamOut, database);
    }

    public void executeCommand(Database database) throws Exception {
        try {
            this.finalCommandArray = this.createFinalCommandArray(database);
            super.executeCommand(database);
        }
        catch (TimeoutException e) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            this.processResult(0, null, null, database);
            String message = e.getMessage() + System.lineSeparator() + "Error: The psql executable failed to return a response with the configured timeout. Please check liquibase.psql.timeout specified in liquibase.psql.conf file, the LIQUIBASE_PSQL_TIMEOUT environment variable, or other config locations. Learn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-psql-integration.html" + System.lineSeparator();
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            Scope.getCurrentScope().getLog(PsqlRunner.class).warning(message);
            throw new LiquibaseException((Throwable)e);
        }
        catch (Exception e) {
            throw new LiquibaseException((Throwable)e);
        }
        finally {
            if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Psql run script can be located at: " + this.outFile.getAbsolutePath());
            }
        }
    }

    private void loadPsqlProperties() {
        this.setExecutable(NativeRunnerUtil.getExecutable(EXECUTABLE_NAME));
        Properties properties = this.getPropertiesFromConf(NativeExecutorRunner.ConfigFile.PSQL);
        this.setupConfProperties(properties);
        this.assignPropertiesFromConfiguration();
        this.addPropertiesToMdc();
        this.handlePsqlExecutable(this.psqlExec);
        this.handleTimeout(this.timeout);
        this.logProperties();
    }

    private void addPropertiesToMdc() {
        Scope.getCurrentScope().addMdcValue("liquibasePsqlKeepTemp", String.valueOf(this.keepTempFile));
        Scope.getCurrentScope().addMdcValue("liquibasePsqlKeepTempPath", this.tempPath);
        Scope.getCurrentScope().addMdcValue("liquibasePsqlKeepTempName", this.tempName);
        Scope.getCurrentScope().addMdcValue("liquibasePsqlLogFile", this.logFile);
    }

    private int determineTimeout(Properties properties) {
        String timeoutString = properties.getProperty("liquibase.psql.timeout");
        if (timeoutString == null) {
            return -1;
        }
        try {
            return Integer.parseInt(timeoutString);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException("Invalid value '" + timeoutString + "' for property 'liquibase.psql.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-psql-integration.html");
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a keep temp file name value of '" + this.tempName + "'");
        }
        if (this.logFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a log file value of '" + this.logFile + "'");
        }
    }

    private void handleArgs(String argsString) {
        if (argsString != null) {
            argsString = argsString.trim();
            Scope.getCurrentScope().addMdcValue("liquibasePsqlArgs", argsString);
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a extra arguments of '" + argsString + "'");
            this.args = StringUtil.splitAndTrim((String)argsString, (String)" ");
        }
    }

    private void handleTimeout(Integer timeout) {
        if (timeout != null) {
            Scope.getCurrentScope().addMdcValue("liquibasePsqlTimeout", String.valueOf(timeout));
            NativeRunnerUtil.validateTimeout(timeout);
            this.setTimeout(String.valueOf(timeout));
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'psql' with a timeout of '" + timeout + "'");
        }
    }

    private void handlePsqlExecutable(File psqlExec) {
        if (psqlExec == null) {
            return;
        }
        Scope.getCurrentScope().addMdcValue("liquibasePsqlPath", psqlExec.toString());
        if (!psqlExec.exists()) {
            throw new UnexpectedLiquibaseException("The executable for the native executor 'psql' cannot be found at path '" + psqlExec.getAbsolutePath() + "' as specified in the liquibase.psql.conf file, the LIQUIBASE_PSQL_* environment variables, or other config locations. Learn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-psql-integration.html.");
        }
        if (!psqlExec.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'psql' executable in the liquibase.psql.conf file at " + psqlExec.getAbsolutePath() + " cannot be executed");
        }
        try {
            this.setExecutable(psqlExec.getCanonicalPath());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Using the 'psql' executable located at:  '" + psqlExec.getCanonicalPath() + "'");
            this.psqlExec = psqlExec;
        }
        catch (IOException ioe) {
            throw new UnexpectedLiquibaseException((Throwable)ioe);
        }
    }

    private void setupConfProperties(Properties properties) {
        if (properties.containsKey(PsqlConfiguration.ConfigurationKeys.getFullKey("keep.temp"))) {
            this.keepTempFile = NativeRunnerUtil.getBooleanFromProperties(properties, PsqlConfiguration.ConfigurationKeys.getFullKey("keep.temp"));
        }
        if (properties.containsKey(PsqlConfiguration.ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = properties.getProperty(PsqlConfiguration.ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (properties.containsKey(PsqlConfiguration.ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = properties.getProperty(PsqlConfiguration.ConfigurationKeys.getFullKey("keep.temp.path"));
        }
        if (properties.containsKey(PsqlConfiguration.ConfigurationKeys.getFullKey("logFile"))) {
            this.logFile = properties.getProperty(PsqlConfiguration.ConfigurationKeys.getFullKey("logFile"));
        }
        if (properties.containsKey("liquibase.psql.path")) {
            this.handlePsqlExecutable(new File(properties.getProperty("liquibase.psql.path")));
        }
        if (properties.containsKey("liquibase.psql.timeout")) {
            this.timeout = this.determineTimeout(properties);
        }
        if (properties.containsKey("liquibase.psql.args")) {
            this.handleArgs(properties.getProperty("liquibase.psql.args"));
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.tempName = PsqlConfiguration.TEMP_NAME.getCurrentValue() != null ? (String)PsqlConfiguration.TEMP_NAME.getCurrentValue() : this.tempName;
        this.tempPath = PsqlConfiguration.TEMP_PATH.getCurrentValue() != null ? (String)PsqlConfiguration.TEMP_PATH.getCurrentValue() : this.tempPath;
        this.logFile = PsqlConfiguration.LOG_FILE.getCurrentValue() != null ? (String)PsqlConfiguration.LOG_FILE.getCurrentValue() : this.logFile;
        this.keepTempFile = PsqlConfiguration.TEMP_KEEP.getCurrentValue() != null ? (Boolean)PsqlConfiguration.TEMP_KEEP.getCurrentValue() : this.keepTempFile;
        Integer n = this.timeout = PsqlConfiguration.TIMEOUT.getCurrentValue() != null ? (Integer)PsqlConfiguration.TIMEOUT.getCurrentValue() : this.timeout;
        if (PsqlConfiguration.PATH.getCurrentValue() != null) {
            this.handlePsqlExecutable(new File((String)PsqlConfiguration.PATH.getCurrentValue()));
        }
        if (PsqlConfiguration.ARGS.getCurrentValue() != null) {
            this.handleArgs((String)PsqlConfiguration.ARGS.getCurrentValue());
        }
    }

    private void writeSqlStrings(Database database) throws Exception {
        if (this.sqlStrings == null || this.sqlStrings.length == 0) {
            return;
        }
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        log.info("Creating the SQL run script");
        NativeToolFileCreator psqlFileCreator = new NativeToolFileCreator(this.changeSet, this.tempName, this.tempPath, true, this.keepTempFile == null ? ((Boolean)PsqlConfiguration.TEMP_KEEP.getDefaultValue()).booleanValue() : this.keepTempFile.booleanValue(), this.getIntegrationDisplayName(), null);
        try {
            this.outFile = psqlFileCreator.generateTemporaryFile(NativeToolFileCreator.FileTypeEnum.sql);
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        Path path = Paths.get(this.outFile.getAbsolutePath(), new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            if (StringUtil.isNotEmpty((String)database.getDefaultSchemaName())) {
                writer.write(String.format("SET SEARCH_PATH TO %s;%n", database.escapeObjectName(database.getDefaultSchemaName(), Schema.class)));
            }
            this.writeSqlStrings(writer);
            writer.write(";\n");
        }
    }

    protected String buildConnectionString(Database database) {
        if (database == null) {
            return null;
        }
        DatabaseConnection connection = database.getConnection();
        String userName = this.getUserName(connection);
        String password = this.getPassword(connection);
        Pattern pattern = Pattern.compile(".*postgresql://(.*?):(\\d+)/([^?]+).*");
        Matcher matcher = pattern.matcher(connection.getURL());
        String hostname = "";
        String port = "";
        String databaseName = "";
        if (!matcher.matches()) {
            throw new UnexpectedLiquibaseException("Could not determine proper postgres connection url.");
        }
        hostname = matcher.group(1);
        port = matcher.group(2);
        databaseName = matcher.group(3);
        return String.format("postgresql://%s:%s@%s:%s/%s", userName, password, hostname, port, databaseName);
    }

    private String getUserName(DatabaseConnection connection) {
        String userName = null;
        if (connection instanceof ProJdbcConnection) {
            ProJdbcConnection proJdbcConnection = (ProJdbcConnection)connection;
            userName = proJdbcConnection.getUsername();
        }
        if (userName == null) {
            userName = connection.getConnectionUserName();
        }
        return StringUtil.trimToEmpty(userName).replace("@", "%40");
    }

    private String getPassword(DatabaseConnection connection) {
        String password = null;
        if (connection instanceof ProJdbcConnection) {
            ProJdbcConnection proJdbcConnection = (ProJdbcConnection)connection;
            password = proJdbcConnection.getPassword();
        }
        return StringUtil.trimToEmpty(password).replace("@", "%40");
    }
}

