/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.create.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class ColDataType
implements Serializable {
    private String dataType;
    private List<String> argumentsStringList;
    private String characterSet;
    private List<Integer> arrayData = new ArrayList<Integer>();

    public ColDataType() {
    }

    public ColDataType(String dataType) {
        this.dataType = dataType;
    }

    public List<String> getArgumentsStringList() {
        return this.argumentsStringList;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setArgumentsStringList(List<String> list) {
        this.argumentsStringList = list;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public void setDataType(List<String> list) {
        this.dataType = list.stream().collect(Collectors.joining("."));
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public List<Integer> getArrayData() {
        return this.arrayData;
    }

    public void setArrayData(List<Integer> arrayData) {
        this.arrayData = arrayData;
    }

    public String toString() {
        StringBuilder arraySpec = new StringBuilder();
        for (Integer item : this.arrayData) {
            arraySpec.append("[");
            if (item != null) {
                arraySpec.append(item);
            }
            arraySpec.append("]");
        }
        return this.dataType + (this.argumentsStringList != null ? " " + PlainSelect.getStringList(this.argumentsStringList, true, true) : "") + arraySpec.toString() + (this.characterSet != null ? " CHARACTER SET " + this.characterSet : "");
    }

    public ColDataType withDataType(String dataType) {
        this.setDataType(dataType);
        return this;
    }

    public ColDataType withArgumentsStringList(List<String> argumentsStringList) {
        this.setArgumentsStringList(argumentsStringList);
        return this;
    }

    public ColDataType withCharacterSet(String characterSet) {
        this.setCharacterSet(characterSet);
        return this;
    }

    public ColDataType withArrayData(List<Integer> arrayData) {
        this.setArrayData(arrayData);
        return this;
    }

    public ColDataType addArgumentsStringList(String ... argumentsStringList) {
        List collection = Optional.ofNullable(this.getArgumentsStringList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, argumentsStringList);
        return this.withArgumentsStringList(collection);
    }

    public ColDataType addArgumentsStringList(Collection<String> argumentsStringList) {
        List collection = Optional.ofNullable(this.getArgumentsStringList()).orElseGet(ArrayList::new);
        collection.addAll(argumentsStringList);
        return this.withArgumentsStringList(collection);
    }

    public ColDataType addArrayData(Integer ... arrayData) {
        List collection = Optional.ofNullable(this.getArrayData()).orElseGet(ArrayList::new);
        Collections.addAll(collection, arrayData);
        return this.withArrayData(collection);
    }

    public ColDataType addArrayData(Collection<Integer> arrayData) {
        List collection = Optional.ofNullable(this.getArrayData()).orElseGet(ArrayList::new);
        collection.addAll(arrayData);
        return this.withArrayData(collection);
    }
}

