/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.InputStream;
import liquibase.util.MD5Util;

public class CheckSum {
    private int version;
    private String checksum;

    private CheckSum(String checksum, int version) {
        this.checksum = checksum;
        this.version = version;
    }

    public static CheckSum parse(String checksumValue) {
        if (checksumValue == null) {
            return null;
        }
        if (checksumValue.startsWith(CheckSum.getCurrentVersion() + ":")) {
            return new CheckSum(checksumValue.substring(2), CheckSum.getCurrentVersion());
        }
        return new CheckSum(checksumValue, 1);
    }

    public static int getCurrentVersion() {
        return 2;
    }

    public static CheckSum compute(String valueToChecksum) {
        return new CheckSum(MD5Util.computeMD5(valueToChecksum), CheckSum.getCurrentVersion());
    }

    public static CheckSum compute(InputStream stream) {
        return new CheckSum(MD5Util.computeMD5(stream), CheckSum.getCurrentVersion());
    }

    public String toString() {
        return this.version + ":" + this.checksum;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CheckSum && this.toString().equals(obj.toString());
    }
}

