/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.core.AnonymousChange;
import liquibase.change.core.DropForeignKeyConstraintChange;
import liquibase.change.core.DropSequenceChange;
import liquibase.change.core.DropTableChange;
import liquibase.change.core.DropViewChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.View;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DatabaseException;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.DateParseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.StatementNotSupportedOnDatabaseException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.DatabaseSnapshotGeneratorFactory;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.AddUniqueConstraintStatement;
import liquibase.statement.core.ClearDatabaseChangeLogTableStatement;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.CreateDatabaseChangeLogTableStatement;
import liquibase.statement.core.GetNextChangeSetSequenceValueStatement;
import liquibase.statement.core.GetViewDefinitionStatement;
import liquibase.statement.core.MarkChangeSetRanStatement;
import liquibase.statement.core.ModifyDataTypeStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.RemoveChangeSetRanStatusStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogStatement;
import liquibase.statement.core.SetNullableStatement;
import liquibase.statement.core.TagDatabaseStatement;
import liquibase.statement.core.UpdateChangeSetChecksumStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.util.ISODateFormat;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabase
implements Database {
    private DatabaseConnection connection;
    private String defaultSchemaName;
    protected String currentDateTimeFunction;
    protected List<DatabaseFunction> databaseFunctions = new ArrayList<DatabaseFunction>();
    private List<RanChangeSet> ranChangeSetList;
    private static Pattern CREATE_VIEW_AS_PATTERN = Pattern.compile("^CREATE\\s+.*?VIEW\\s+.*?AS\\s+", 34);
    private String databaseChangeLogTableName = System.getProperty("liquibase.databaseChangeLogTableName") == null ? "DatabaseChangeLog".toUpperCase() : System.getProperty("liquibase.databaseChangeLogTableName");
    private String databaseChangeLogLockTableName = System.getProperty("liquibase.databaseChangeLogLockTableName") == null ? "DatabaseChangeLogLock".toUpperCase() : System.getProperty("liquibase.databaseChangeLogLockTableName");
    private Integer lastChangeSetSequenceValue;
    private boolean canCacheLiquibaseTableInfo = false;
    private boolean hasDatabaseChangeLogTable = false;
    private boolean hasDatabaseChangeLogLockTable = false;

    protected AbstractDatabase() {
    }

    @Override
    public boolean requiresPassword() {
        return true;
    }

    @Override
    public boolean requiresUsername() {
        return true;
    }

    @Override
    public DatabaseObject[] getContainingObjects() {
        return null;
    }

    @Override
    public DatabaseConnection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(DatabaseConnection conn) {
        LogFactory.getLogger().debug("Connected to " + conn.getConnectionUserName() + "@" + conn.getURL());
        this.connection = conn;
        try {
            this.connection.setAutoCommit(this.getAutoCommitMode());
        }
        catch (DatabaseException sqle) {
            LogFactory.getLogger().warning("Can not set auto commit to " + this.getAutoCommitMode() + " on connection");
        }
    }

    @Override
    public boolean getAutoCommitMode() {
        return !this.supportsDDLInTransaction();
    }

    @Override
    public boolean supportsDDLInTransaction() {
        return true;
    }

    @Override
    public String getDatabaseProductName() {
        try {
            return this.connection.getDatabaseProductName();
        }
        catch (DatabaseException e) {
            throw new RuntimeException("Cannot get database name");
        }
    }

    @Override
    public String getDatabaseProductVersion() throws DatabaseException {
        try {
            return this.connection.getDatabaseProductVersion();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws DatabaseException {
        try {
            return this.connection.getDatabaseMajorVersion();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws DatabaseException {
        try {
            return this.connection.getDatabaseMinorVersion();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public String getDefaultCatalogName() throws DatabaseException {
        return null;
    }

    protected String getDefaultDatabaseSchemaName() throws DatabaseException {
        return this.getConnection().getConnectionUserName();
    }

    @Override
    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    @Override
    public void setDefaultSchemaName(String schemaName) throws DatabaseException {
        this.defaultSchemaName = schemaName;
    }

    protected Set<String> getSystemTablesAndViews() {
        return new HashSet<String>();
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public void setCurrentDateTimeFunction(String function) {
        if (function != null) {
            this.currentDateTimeFunction = function;
        }
    }

    @Override
    public String getDateLiteral(String isoDate) {
        if (this.isDateOnly(isoDate) || this.isTimeOnly(isoDate)) {
            return "'" + isoDate + "'";
        }
        if (this.isDateTime(isoDate)) {
            return "'" + isoDate.replace('T', ' ') + "'";
        }
        return "BAD_DATE_FORMAT:" + isoDate;
    }

    @Override
    public String getDateTimeLiteral(Timestamp date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getDateLiteral(Date date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getTimeLiteral(Time date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getDateLiteral(java.util.Date date) {
        if (date instanceof Date) {
            return this.getDateLiteral((Date)date);
        }
        if (date instanceof Time) {
            return this.getTimeLiteral((Time)date);
        }
        if (date instanceof Timestamp) {
            return this.getDateTimeLiteral((Timestamp)date);
        }
        throw new RuntimeException("Unexpected type: " + date.getClass().getName());
    }

    @Override
    public java.util.Date parseDate(String dateAsString) throws DateParseException {
        try {
            if (dateAsString.indexOf(" ") > 0) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateAsString);
            }
            if (dateAsString.indexOf("T") > 0) {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(dateAsString);
            }
            if (dateAsString.indexOf(":") > 0) {
                return new SimpleDateFormat("HH:mm:ss").parse(dateAsString);
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(dateAsString);
        }
        catch (ParseException e) {
            throw new DateParseException(dateAsString);
        }
    }

    protected boolean isDateOnly(String isoDate) {
        return isoDate.length() == "yyyy-MM-dd".length();
    }

    protected boolean isDateTime(String isoDate) {
        return isoDate.length() >= "yyyy-MM-ddThh:mm:ss".length();
    }

    protected boolean isTimeOnly(String isoDate) {
        return isoDate.length() == "hh:mm:ss".length();
    }

    @Override
    public String getLineComment() {
        return "--";
    }

    @Override
    public String getAutoIncrementClause() {
        return "AUTO_INCREMENT";
    }

    @Override
    public String getConcatSql(String ... values) {
        StringBuffer returnString = new StringBuffer();
        for (String value : values) {
            returnString.append(value).append(" || ");
        }
        return returnString.toString().replaceFirst(" \\|\\| $", "");
    }

    @Override
    public String getDatabaseChangeLogTableName() {
        return this.databaseChangeLogTableName;
    }

    @Override
    public String getDatabaseChangeLogLockTableName() {
        return this.databaseChangeLogLockTableName;
    }

    @Override
    public void setDatabaseChangeLogTableName(String tableName) {
        this.databaseChangeLogTableName = tableName;
    }

    @Override
    public void setDatabaseChangeLogLockTableName(String tableName) {
        this.databaseChangeLogLockTableName = tableName;
    }

    @Override
    public void checkDatabaseChangeLogTable(boolean updateExistingNullChecksums, DatabaseChangeLog databaseChangeLog) throws DatabaseException {
        Executor executor = ExecutorService.getInstance().getExecutor(this);
        Table changeLogTable = DatabaseSnapshotGeneratorFactory.getInstance().getGenerator(this).getDatabaseChangeLogTable(this);
        ArrayList<SqlStatement> statementsToExecute = new ArrayList<SqlStatement>();
        boolean changeLogCreateAttempted = false;
        if (changeLogTable != null) {
            String md5sum;
            List<Map> md5sumRS;
            boolean hasExecTypeColumn;
            boolean hasDescription = changeLogTable.getColumn("DESCRIPTION") != null;
            boolean hasComments = changeLogTable.getColumn("COMMENTS") != null;
            boolean hasTag = changeLogTable.getColumn("TAG") != null;
            boolean hasLiquibase = changeLogTable.getColumn("LIQUIBASE") != null;
            boolean liquibaseColumnNotRightSize = changeLogTable.getColumn("LIQUIBASE").getColumnSize() != 20;
            boolean hasOrderExecuted = changeLogTable.getColumn("ORDEREXECUTED") != null;
            boolean checksumNotRightSize = changeLogTable.getColumn("MD5SUM").getColumnSize() != 35;
            boolean bl = hasExecTypeColumn = changeLogTable.getColumn("EXECTYPE") != null;
            if (!hasDescription) {
                executor.comment("Adding missing databasechangelog.description column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "DESCRIPTION", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasTag) {
                executor.comment("Adding missing databasechangelog.tag column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "TAG", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasComments) {
                executor.comment("Adding missing databasechangelog.comments column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "COMMENTS", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasLiquibase) {
                executor.comment("Adding missing databasechangelog.liquibase column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "LIQUIBASE", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasOrderExecuted) {
                executor.comment("Adding missing databasechangelog.orderexecuted column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "ORDEREXECUTED", "INT", null, new ColumnConstraint[0]));
                statementsToExecute.add(new AddUniqueConstraintStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "ORDEREXECUTED", "UQ_LB_ORDEREXEC"));
                statementsToExecute.add(new UpdateStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()).addNewColumnValue("ORDEREXECUTED", -1));
                statementsToExecute.add(new SetNullableStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "ORDEREXECUTED", "INT", false));
            }
            if (checksumNotRightSize) {
                executor.comment("Modifying size of databasechangelog.md5sum column");
                statementsToExecute.add(new ModifyDataTypeStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "MD5SUM", "VARCHAR(35)"));
            }
            if (liquibaseColumnNotRightSize) {
                executor.comment("Modifying size of databasechangelog.liquibase column");
                statementsToExecute.add(new ModifyDataTypeStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "LIQUIBASE", "VARCHAR(20)"));
            }
            if (!hasExecTypeColumn) {
                executor.comment("Adding missing databasechangelog.exectype column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "EXECTYPE", "VARCHAR(10)", null, new ColumnConstraint[0]));
                statementsToExecute.add(new SetNullableStatement(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "EXECTYPE", "VARCHAR(10)", false));
            }
            if ((md5sumRS = ExecutorService.getInstance().getExecutor(this).queryForList(new SelectFromDatabaseChangeLogStatement(new SelectFromDatabaseChangeLogStatement.ByNotNullCheckSum(), "MD5SUM"))).size() > 0 && !(md5sum = md5sumRS.get(0).get("MD5SUM").toString()).startsWith(CheckSum.getCurrentVersion() + ":")) {
                executor.comment("DatabaseChangeLog checksums are an incompatible version.  Setting them to null so they will be updated on next database update");
                statementsToExecute.add(new RawSqlStatement("UPDATE " + this.escapeTableName(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()) + " SET MD5SUM=null"));
            }
        } else if (!changeLogCreateAttempted) {
            executor.comment("Create Database Change Log Table");
            CreateDatabaseChangeLogTableStatement createTableStatement = new CreateDatabaseChangeLogTableStatement();
            if (!this.canCreateChangeLogTable()) {
                throw new DatabaseException("Cannot create " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName()) + " table for your database.\n\n" + "Please construct it manually using the following SQL as a base and re-run Liquibase:\n\n" + createTableStatement);
            }
            statementsToExecute.add(createTableStatement);
            LogFactory.getLogger().info("Creating database history table with name: " + this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName()));
        }
        for (SqlStatement sql : statementsToExecute) {
            executor.execute(sql);
            this.commit();
        }
        if (updateExistingNullChecksums) {
            for (RanChangeSet ranChangeSet : this.getRanChangeSetList()) {
                ChangeSet changeSet;
                if (ranChangeSet.getLastCheckSum() != null || (changeSet = databaseChangeLog.getChangeSet(ranChangeSet)) == null) continue;
                LogFactory.getLogger().info("Setting null checksum on changeSet " + changeSet + " to correct value");
                executor.execute(new UpdateChangeSetChecksumStatement(changeSet));
            }
            this.commit();
            this.ranChangeSetList = null;
        }
    }

    protected boolean canCreateChangeLogTable() throws DatabaseException {
        return true;
    }

    @Override
    public void setCanCacheLiquibaseTableInfo(boolean canCacheLiquibaseTableInfo) {
        this.canCacheLiquibaseTableInfo = canCacheLiquibaseTableInfo;
        this.hasDatabaseChangeLogTable = false;
        this.hasDatabaseChangeLogLockTable = false;
    }

    @Override
    public boolean hasDatabaseChangeLogTable() throws DatabaseException {
        if (this.hasDatabaseChangeLogTable) {
            return true;
        }
        boolean hasTable = DatabaseSnapshotGeneratorFactory.getInstance().getGenerator(this).hasDatabaseChangeLogTable(this);
        if (this.canCacheLiquibaseTableInfo) {
            this.hasDatabaseChangeLogTable = hasTable;
        }
        return hasTable;
    }

    @Override
    public boolean hasDatabaseChangeLogLockTable() throws DatabaseException {
        if (this.hasDatabaseChangeLogLockTable) {
            return true;
        }
        boolean hasTable = DatabaseSnapshotGeneratorFactory.getInstance().getGenerator(this).hasDatabaseChangeLogLockTable(this);
        if (this.canCacheLiquibaseTableInfo) {
            this.hasDatabaseChangeLogLockTable = hasTable;
        }
        return hasTable;
    }

    @Override
    public String getLiquibaseSchemaName() {
        return this.getDefaultSchemaName();
    }

    @Override
    public void checkDatabaseChangeLogLockTable() throws DatabaseException {
        Executor executor = ExecutorService.getInstance().getExecutor(this);
        if (!this.hasDatabaseChangeLogLockTable()) {
            executor.comment("Create Database Lock Table");
            executor.execute(new CreateDatabaseChangeLogLockTableStatement());
            this.commit();
            LogFactory.getLogger().debug("Created database lock table with name: " + this.escapeTableName(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogLockTableName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDatabaseObjects(String schema) throws DatabaseException {
        try {
            DatabaseSnapshot snapshot = DatabaseSnapshotGeneratorFactory.getInstance().createSnapshot(this, schema, new HashSet<DiffStatusListener>());
            ArrayList<AbstractChange> dropChanges = new ArrayList<AbstractChange>();
            for (View view : snapshot.getViews()) {
                DropViewChange dropViewChange = new DropViewChange();
                dropViewChange.setViewName(view.getName());
                dropViewChange.setSchemaName(schema);
                dropChanges.add(dropViewChange);
            }
            if (!this.supportsForeignKeyDisable()) {
                for (ForeignKey fk : snapshot.getForeignKeys()) {
                    DropForeignKeyConstraintChange dropForeignKeyConstraintChange = new DropForeignKeyConstraintChange();
                    dropForeignKeyConstraintChange.setBaseTableSchemaName(schema);
                    dropForeignKeyConstraintChange.setBaseTableName(fk.getForeignKeyTable().getName());
                    dropForeignKeyConstraintChange.setConstraintName(fk.getName());
                    dropChanges.add(dropForeignKeyConstraintChange);
                }
            }
            for (Table table : snapshot.getTables()) {
                DropTableChange dropTableChange = new DropTableChange();
                dropTableChange.setSchemaName(schema);
                dropTableChange.setTableName(table.getName());
                dropTableChange.setCascadeConstraints(true);
                dropChanges.add(dropTableChange);
            }
            if (this.supportsSequences()) {
                for (Sequence seq : snapshot.getSequences()) {
                    DropSequenceChange dropSequenceChange = new DropSequenceChange();
                    dropSequenceChange.setSequenceName(seq.getName());
                    dropSequenceChange.setSchemaName(schema);
                    dropChanges.add(dropSequenceChange);
                }
            }
            if (snapshot.hasDatabaseChangeLogTable()) {
                dropChanges.add(new AnonymousChange(new ClearDatabaseChangeLogTableStatement(schema)));
            }
            boolean reEnableFK = this.supportsForeignKeyDisable() && this.disableForeignKeyChecks();
            try {
                for (Change change : dropChanges) {
                    for (SqlStatement statement : change.generateStatements(this)) {
                        ExecutorService.getInstance().getExecutor(this).execute(statement);
                    }
                }
            }
            finally {
                if (reEnableFK) {
                    this.enableForeignKeyChecks();
                }
            }
        }
        finally {
            this.commit();
        }
    }

    @Override
    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        if ("information_schema".equalsIgnoreCase(schemaName)) {
            return true;
        }
        if (tableName.equalsIgnoreCase(this.getDatabaseChangeLogLockTableName())) {
            return true;
        }
        return this.getSystemTablesAndViews().contains(tableName);
    }

    @Override
    public boolean isSystemView(String catalogName, String schemaName, String viewName) {
        if ("information_schema".equalsIgnoreCase(schemaName)) {
            return true;
        }
        return this.getSystemTablesAndViews().contains(viewName);
    }

    @Override
    public boolean isLiquibaseTable(String tableName) {
        return tableName.equalsIgnoreCase(this.getDatabaseChangeLogTableName()) || tableName.equalsIgnoreCase(this.getDatabaseChangeLogLockTableName());
    }

    @Override
    public void tag(String tagString) throws DatabaseException {
        Executor executor = ExecutorService.getInstance().getExecutor(this);
        try {
            int rowsUpdated;
            int totalRows = ExecutorService.getInstance().getExecutor(this).queryForInt(new SelectFromDatabaseChangeLogStatement("COUNT(*)"));
            if (totalRows == 0) {
                ChangeSet emptyChangeSet = new ChangeSet(String.valueOf(new java.util.Date().getTime()), "liquibase", false, false, "liquibase-internal", "liquibase-internal", null, null);
                this.markChangeSetExecStatus(emptyChangeSet, ChangeSet.ExecType.EXECUTED);
            }
            if ((rowsUpdated = executor.update(new TagDatabaseStatement(tagString))) == 0) {
                throw new DatabaseException("Did not tag database change log correctly");
            }
            this.commit();
            this.getRanChangeSetList().get(this.getRanChangeSetList().size() - 1).setTag(tagString);
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean doesTagExist(String tag) throws DatabaseException {
        int count = ExecutorService.getInstance().getExecutor(this).queryForInt(new SelectFromDatabaseChangeLogStatement(new SelectFromDatabaseChangeLogStatement.ByTag("tag"), "COUNT(*)"));
        return count > 0;
    }

    public String toString() {
        if (this.getConnection() == null) {
            return this.getTypeName() + " Database";
        }
        return this.getConnection().getConnectionUserName() + " @ " + this.getConnection().getURL() + (this.getDefaultSchemaName() == null ? "" : " (Default Schema: " + this.getDefaultSchemaName() + ")");
    }

    @Override
    public boolean shouldQuoteValue(String value) {
        return true;
    }

    @Override
    public String getViewDefinition(String schemaName, String viewName) throws DatabaseException {
        String definition;
        if (schemaName == null) {
            schemaName = this.convertRequestedSchemaToSchema(null);
        }
        if ((definition = (String)ExecutorService.getInstance().getExecutor(this).queryForObject(new GetViewDefinitionStatement(schemaName, viewName), String.class)) == null) {
            return null;
        }
        return CREATE_VIEW_AS_PATTERN.matcher(definition).replaceFirst("");
    }

    @Override
    public String escapeTableName(String schemaName, String tableName) {
        if (schemaName == null) {
            schemaName = this.getDefaultSchemaName();
        }
        if (StringUtils.trimToNull(schemaName) == null || !this.supportsSchemas()) {
            return this.escapeDatabaseObject(tableName);
        }
        return this.escapeDatabaseObject(schemaName) + "." + this.escapeDatabaseObject(tableName);
    }

    @Override
    public String escapeDatabaseObject(String objectName) {
        return objectName;
    }

    @Override
    public String escapeIndexName(String schemaName, String indexName) {
        if (StringUtils.trimToNull(schemaName) == null || !this.supportsSchemas()) {
            return this.escapeDatabaseObject(indexName);
        }
        return this.escapeDatabaseObject(schemaName) + "." + this.escapeDatabaseObject(indexName);
    }

    @Override
    public String escapeSequenceName(String schemaName, String sequenceName) {
        if (schemaName == null) {
            schemaName = this.getDefaultSchemaName();
        }
        if (StringUtils.trimToNull(schemaName) == null || !this.supportsSchemas()) {
            return this.escapeDatabaseObject(sequenceName);
        }
        return this.escapeDatabaseObject(schemaName) + "." + this.escapeDatabaseObject(sequenceName);
    }

    @Override
    public String escapeConstraintName(String constraintName) {
        return this.escapeDatabaseObject(constraintName);
    }

    @Override
    public String escapeColumnName(String schemaName, String tableName, String columnName) {
        if (schemaName == null) {
            schemaName = this.getDefaultSchemaName();
        }
        return this.escapeDatabaseObject(columnName);
    }

    @Override
    public String escapeColumnNameList(String columnNames) {
        StringBuffer sb = new StringBuffer();
        for (String columnName : columnNames.split(",")) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.escapeDatabaseObject(columnName.trim()));
        }
        return sb.toString();
    }

    @Override
    public String convertRequestedSchemaToCatalog(String requestedSchema) throws DatabaseException {
        if (this.getDefaultCatalogName() == null) {
            return null;
        }
        if (requestedSchema == null) {
            return this.getDefaultCatalogName();
        }
        return StringUtils.trimToNull(requestedSchema);
    }

    @Override
    public String convertRequestedSchemaToSchema(String requestedSchema) throws DatabaseException {
        String returnSchema = requestedSchema;
        if (returnSchema == null) {
            returnSchema = this.getDefaultDatabaseSchemaName();
        }
        if (returnSchema != null) {
            returnSchema = returnSchema.toUpperCase();
        }
        return returnSchema;
    }

    @Override
    public boolean supportsSchemas() {
        return true;
    }

    @Override
    public String generatePrimaryKeyName(String tableName) {
        return "PK_" + tableName.toUpperCase();
    }

    @Override
    public String escapeViewName(String schemaName, String viewName) {
        return this.escapeTableName(schemaName, viewName);
    }

    @Override
    public ChangeSet.RunStatus getRunStatus(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        if (!this.hasDatabaseChangeLogTable()) {
            return ChangeSet.RunStatus.NOT_RAN;
        }
        RanChangeSet foundRan = this.getRanChangeSet(changeSet);
        if (foundRan == null) {
            return ChangeSet.RunStatus.NOT_RAN;
        }
        if (foundRan.getLastCheckSum() == null) {
            try {
                LogFactory.getLogger().info("Updating NULL md5sum for " + changeSet.toString());
                ExecutorService.getInstance().getExecutor(this).execute(new RawSqlStatement("UPDATE " + this.escapeTableName(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()) + " SET MD5SUM='" + changeSet.generateCheckSum().toString() + "' WHERE ID='" + changeSet.getId() + "' AND AUTHOR='" + changeSet.getAuthor() + "' AND FILENAME='" + changeSet.getFilePath() + "'"));
                this.commit();
            }
            catch (DatabaseException e) {
                throw new DatabaseException(e);
            }
            return ChangeSet.RunStatus.ALREADY_RAN;
        }
        if (foundRan.getLastCheckSum().equals(changeSet.generateCheckSum())) {
            return ChangeSet.RunStatus.ALREADY_RAN;
        }
        if (changeSet.shouldRunOnChange()) {
            return ChangeSet.RunStatus.RUN_AGAIN;
        }
        return ChangeSet.RunStatus.INVALID_MD5SUM;
    }

    @Override
    public RanChangeSet getRanChangeSet(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        if (!this.hasDatabaseChangeLogTable()) {
            throw new DatabaseHistoryException("Database change table does not exist");
        }
        RanChangeSet foundRan = null;
        for (RanChangeSet ranChange : this.getRanChangeSetList()) {
            if (!ranChange.isSameAs(changeSet)) continue;
            foundRan = ranChange;
            break;
        }
        return foundRan;
    }

    @Override
    public List<RanChangeSet> getRanChangeSetList() throws DatabaseException {
        if (this.ranChangeSetList != null) {
            return this.ranChangeSetList;
        }
        String databaseChangeLogTableName = this.escapeTableName(this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName());
        this.ranChangeSetList = new ArrayList<RanChangeSet>();
        if (this.hasDatabaseChangeLogTable()) {
            LogFactory.getLogger().info("Reading from " + databaseChangeLogTableName);
            SelectFromDatabaseChangeLogStatement select = new SelectFromDatabaseChangeLogStatement("FILENAME", "AUTHOR", "ID", "MD5SUM", "DATEEXECUTED", "ORDEREXECUTED", "TAG", "EXECTYPE").setOrderBy("DATEEXECUTED ASC", "ORDEREXECUTED ASC");
            List<Map> results = ExecutorService.getInstance().getExecutor(this).queryForList(select);
            for (Map rs : results) {
                String fileName = rs.get("FILENAME").toString();
                String author = rs.get("AUTHOR").toString();
                String id = rs.get("ID").toString();
                String md5sum = rs.get("MD5SUM") == null ? null : rs.get("MD5SUM").toString();
                java.util.Date dateExecuted = (java.util.Date)rs.get("DATEEXECUTED");
                String tag = rs.get("TAG") == null ? null : rs.get("TAG").toString();
                String execType = rs.get("EXECTYPE") == null ? null : rs.get("EXECTYPE").toString();
                RanChangeSet ranChangeSet = new RanChangeSet(fileName, id, author, CheckSum.parse(md5sum), dateExecuted, tag, ChangeSet.ExecType.valueOf(execType));
                this.ranChangeSetList.add(ranChangeSet);
            }
        }
        return this.ranChangeSetList;
    }

    @Override
    public java.util.Date getRanDate(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        RanChangeSet ranChange = this.getRanChangeSet(changeSet);
        if (ranChange == null) {
            return null;
        }
        return ranChange.getDateExecuted();
    }

    @Override
    public void markChangeSetExecStatus(ChangeSet changeSet, ChangeSet.ExecType execType) throws DatabaseException {
        ExecutorService.getInstance().getExecutor(this).execute(new MarkChangeSetRanStatement(changeSet, execType));
        this.commit();
        this.getRanChangeSetList().add(new RanChangeSet(changeSet));
    }

    @Override
    public void removeRanStatus(ChangeSet changeSet) throws DatabaseException {
        ExecutorService.getInstance().getExecutor(this).execute(new RemoveChangeSetRanStatusStatement(changeSet));
        this.commit();
        this.getRanChangeSetList().remove(new RanChangeSet(changeSet));
    }

    @Override
    public String escapeStringForDatabase(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("'", "''");
    }

    @Override
    public void commit() throws DatabaseException {
        try {
            this.getConnection().commit();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void rollback() throws DatabaseException {
        try {
            this.getConnection().rollback();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDatabase that = (AbstractDatabase)o;
        return !(this.connection == null ? that.connection != null : !this.connection.equals(that.connection));
    }

    public int hashCode() {
        return this.connection != null ? this.connection.hashCode() : 0;
    }

    @Override
    public void close() throws DatabaseException {
        try {
            DatabaseConnection connection = this.getConnection();
            if (connection != null) {
                connection.close();
            }
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return true;
    }

    @Override
    public boolean isAutoCommit() throws DatabaseException {
        try {
            return this.getConnection().getAutoCommit();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void setAutoCommit(boolean b) throws DatabaseException {
        try {
            this.getConnection().setAutoCommit(b);
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean isLocalDatabase() throws DatabaseException {
        DatabaseConnection connection = this.getConnection();
        if (connection == null) {
            return true;
        }
        String url = connection.getURL();
        return url.indexOf("localhost") >= 0 || url.indexOf("127.0.0.1") >= 0;
    }

    @Override
    public void executeStatements(Change change, DatabaseChangeLog changeLog, List<SqlVisitor> sqlVisitors) throws LiquibaseException, UnsupportedChangeException {
        SqlStatement[] statements = change.generateStatements(this);
        this.execute(statements, sqlVisitors);
    }

    @Override
    public void execute(SqlStatement[] statements, List<SqlVisitor> sqlVisitors) throws LiquibaseException {
        for (SqlStatement statement : statements) {
            LogFactory.getLogger().debug("Executing Statement: " + statement);
            ExecutorService.getInstance().getExecutor(this).execute(statement, sqlVisitors);
        }
    }

    @Override
    public void saveStatements(Change change, List<SqlVisitor> sqlVisitors, Writer writer) throws IOException, UnsupportedChangeException, StatementNotSupportedOnDatabaseException, LiquibaseException {
        SqlStatement[] statements;
        for (SqlStatement statement : statements = change.generateStatements(this)) {
            for (Sql sql : SqlGeneratorFactory.getInstance().generateSql(statement, this)) {
                writer.append(sql.toSql()).append(sql.getEndDelimiter()).append(StreamUtil.getLineSeparator()).append(StreamUtil.getLineSeparator());
            }
        }
    }

    @Override
    public void executeRollbackStatements(Change change, List<SqlVisitor> sqlVisitors) throws LiquibaseException, UnsupportedChangeException, RollbackImpossibleException {
        SqlStatement[] statements = change.generateRollbackStatements(this);
        ArrayList<SqlVisitor> rollbackVisitors = new ArrayList<SqlVisitor>();
        if (sqlVisitors != null) {
            for (SqlVisitor visitor : sqlVisitors) {
                if (!visitor.isApplyToRollback()) continue;
                rollbackVisitors.add(visitor);
            }
        }
        this.execute(statements, rollbackVisitors);
    }

    @Override
    public void saveRollbackStatement(Change change, List<SqlVisitor> sqlVisitors, Writer writer) throws IOException, UnsupportedChangeException, RollbackImpossibleException, StatementNotSupportedOnDatabaseException, LiquibaseException {
        SqlStatement[] statements;
        for (SqlStatement statement : statements = change.generateRollbackStatements(this)) {
            for (Sql sql : SqlGeneratorFactory.getInstance().generateSql(statement, this)) {
                writer.append(sql.toSql()).append(sql.getEndDelimiter()).append("\n\n");
            }
        }
    }

    @Override
    public int getNextChangeSetSequenceValue() throws LiquibaseException {
        if (this.lastChangeSetSequenceValue == null) {
            this.lastChangeSetSequenceValue = this.getConnection() == null ? Integer.valueOf(0) : Integer.valueOf(ExecutorService.getInstance().getExecutor(this).queryForInt(new GetNextChangeSetSequenceValueStatement()));
        }
        this.lastChangeSetSequenceValue = this.lastChangeSetSequenceValue + 1;
        return this.lastChangeSetSequenceValue;
    }

    public Table getTable(String schemaName, String tableName) throws DatabaseException {
        return DatabaseSnapshotGeneratorFactory.getInstance().getGenerator(this).getTable(schemaName, tableName, this);
    }

    @Override
    public List<DatabaseFunction> getDatabaseFunctions() {
        return this.databaseFunctions;
    }

    @Override
    public void reset() {
        this.ranChangeSetList = null;
    }

    @Override
    public boolean supportsForeignKeyDisable() {
        return false;
    }

    @Override
    public boolean disableForeignKeyChecks() throws DatabaseException {
        throw new DatabaseException("ForeignKeyChecks Management not supported");
    }

    @Override
    public void enableForeignKeyChecks() throws DatabaseException {
        throw new DatabaseException("ForeignKeyChecks Management not supported");
    }
}

