/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "PostgreSQL";
    private Set<String> systemTablesAndViews = new HashSet<String>();
    private String defaultDatabaseSchemaName;
    private String[] reservedWords = new String[]{"ALL", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASYMMETRIC", "AUTHORIZATION", "BETWEEN", "BINARY", "BOTH", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "CONSTRAINT", "CORRESPONDING", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "EXCEPT", "FALSE", "FOR", "FOREIGN", "FREEZE", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "ILIKE", "IN", "INITIALLY", "INNER", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NEW", "NOT", "NOTNULL", "NULL", "OFF", "OFFSET", "OLD", "ON", "ONLY", "OPEN", "OR", "ORDER", "OUTER", "OVERLAPS", "PLACING", "PRIMARY", "REFERENCES", "RETURNING", "RIGHT", "SELECT", "SESSION_USER", "SIMILAR", "SOME", "SYMMETRIC", "TABLE", "THEN", "TO", "TRAILING", "TRUE", "UNION", "UNIQUE", "USER", "USING", "VERBOSE", "WHEN", "WHERE"};

    @Override
    public String getTypeName() {
        return "postgresql";
    }

    @Override
    public Set<String> getSystemTablesAndViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        return null;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "NOW()";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws DatabaseException {
        block5: {
            if (this.defaultDatabaseSchemaName == null) {
                try {
                    List<String> searchPaths = this.getSearchPaths();
                    if (searchPaths == null || searchPaths.size() <= 0) break block5;
                    for (String searchPath : searchPaths) {
                        if (searchPath == null || searchPath.length() <= 0) continue;
                        this.defaultDatabaseSchemaName = searchPath;
                        if (this.defaultDatabaseSchemaName.equals("$user") && this.getConnection().getConnectionUserName() != null) {
                            this.defaultDatabaseSchemaName = !this.schemaExists(this.getConnection().getConnectionUserName()) ? null : this.getConnection().getConnectionUserName();
                        }
                        if (this.defaultDatabaseSchemaName == null) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LogFactory.getLogger().severe("Failed to get default catalog name from postgres", e);
                }
            }
        }
        return this.defaultDatabaseSchemaName;
    }

    @Override
    public String getDefaultCatalogName() throws DatabaseException {
        return "public";
    }

    @Override
    public String getDatabaseChangeLogTableName() {
        return super.getDatabaseChangeLogTableName().toLowerCase();
    }

    @Override
    public String getDatabaseChangeLogLockTableName() {
        return super.getDatabaseChangeLogLockTableName().toLowerCase();
    }

    @Override
    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        return super.isSystemTable(catalogName, schemaName, tableName) || "pg_catalog".equals(schemaName) || "pg_toast".equals(schemaName) || tableName.endsWith("_seq") || tableName.endsWith("_key") || tableName.endsWith("_pkey") || tableName.startsWith("idx_") || tableName.startsWith("pk_");
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public String getAutoIncrementClause() {
        return "";
    }

    @Override
    public String convertRequestedSchemaToSchema(String requestedSchema) throws DatabaseException {
        if (requestedSchema == null) {
            requestedSchema = this.getDefaultSchemaName();
        }
        if (requestedSchema == null) {
            return this.getDefaultCatalogName();
        }
        return StringUtils.trimToNull(requestedSchema).toLowerCase();
    }

    @Override
    public String convertRequestedSchemaToCatalog(String requestedSchema) throws DatabaseException {
        return super.convertRequestedSchemaToCatalog(requestedSchema);
    }

    @Override
    public String escapeDatabaseObject(String objectName) {
        if (objectName == null) {
            return null;
        }
        if (objectName.contains("-") || this.hasCaseProblems(objectName) || this.startsWithNumeric(objectName) || this.isReservedWord(objectName)) {
            return "\"" + objectName + "\"";
        }
        return super.escapeDatabaseObject(objectName);
    }

    private boolean hasCaseProblems(String tableName) {
        return tableName.matches(".*[A-Z].*") && tableName.matches(".*[a-z].*");
    }

    private boolean startsWithNumeric(String tableName) {
        return tableName.matches("^[0-9].*");
    }

    private boolean isReservedWord(String tableName) {
        for (int i = 0; i != this.reservedWords.length; ++i) {
            if (!this.reservedWords[i].toLowerCase().equalsIgnoreCase(tableName)) continue;
            return true;
        }
        return false;
    }

    private List<String> getSearchPaths() {
        ArrayList<String> searchPaths = null;
        try {
            String searchPathResult;
            DatabaseConnection con = this.getConnection();
            if (con != null && (searchPathResult = (String)ExecutorService.getInstance().getExecutor(this).queryForObject(new RawSqlStatement("SHOW search_path"), String.class)) != null) {
                String[] dirtySearchPaths = searchPathResult.split("\\,");
                searchPaths = new ArrayList<String>();
                for (String searchPath : dirtySearchPaths) {
                    if ((searchPath = searchPath.trim()).equals("\"$user\"")) {
                        searchPath = "$user";
                    }
                    searchPaths.add(searchPath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogFactory.getLogger().severe("Failed to get default catalog name from postgres", e);
        }
        return searchPaths;
    }

    private boolean catalogExists(String catalogName) throws DatabaseException {
        if (catalogName != null) {
            return this.runExistsQuery("select count(*) from information_schema.schemata where catalog_name='" + catalogName + "'");
        }
        return false;
    }

    private boolean schemaExists(String schemaName) throws DatabaseException {
        return schemaName != null && this.runExistsQuery("select count(*) from information_schema.schemata where schema_name='" + schemaName + "'");
    }

    private boolean runExistsQuery(String query) throws DatabaseException {
        Long count = ExecutorService.getInstance().getExecutor(this).queryForLong(new RawSqlStatement(query));
        return count != null && count > 0L;
    }

    @Override
    public String escapeIndexName(String schemaName, String indexName) {
        return indexName;
    }
}

