/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion;

import java.util.Comparator;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.database.typeconversion.TypeConverter;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.ServiceLocator;

public class TypeConverterFactory {
    private static TypeConverterFactory instance;

    public static TypeConverterFactory getInstance() {
        if (instance == null) {
            instance = new TypeConverterFactory();
        }
        return instance;
    }

    public TypeConverter findTypeConverter(Database database) {
        TreeSet<TypeConverter> converters = new TreeSet<TypeConverter>(new Comparator<TypeConverter>(){

            @Override
            public int compare(TypeConverter o1, TypeConverter o2) {
                return Integer.valueOf(o1.getPriority()).compareTo(o2.getPriority());
            }
        });
        for (Class converterClass : ServiceLocator.getInstance().findClasses(TypeConverter.class)) {
            try {
                TypeConverter converter = (TypeConverter)converterClass.newInstance();
                if (!converter.supports(database)) continue;
                converters.add(converter);
            }
            catch (Exception e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
        return (TypeConverter)converters.last();
    }
}

