/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.structure.type.BooleanType;
import liquibase.database.structure.type.ClobType;
import liquibase.database.structure.type.DataType;
import liquibase.database.structure.type.DateTimeType;
import liquibase.database.typeconversion.core.AbstractTypeConverter;

public class MySQLTypeConverter
extends AbstractTypeConverter {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof MySQLDatabase;
    }

    public BooleanType getBooleanType() {
        return new BooleanType.NumericBooleanType("TINYINT(1)");
    }

    public ClobType getClobType() {
        return new ClobType("TEXT");
    }

    protected DataType getDataType(String columnTypeString, Boolean autoIncrement, String dataTypeName, String precision) {
        if (columnTypeString.equalsIgnoreCase("timestamp")) {
            return new DateTimeType("TIMESTAMP");
        }
        return super.getDataType(columnTypeString, autoIncrement, dataTypeName, precision);
    }
}

