/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import java.text.ParseException;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.structure.type.BigIntType;
import liquibase.database.structure.type.BooleanType;
import liquibase.database.structure.type.CurrencyType;
import liquibase.database.structure.type.CustomType;
import liquibase.database.structure.type.DataType;
import liquibase.database.structure.type.DateTimeType;
import liquibase.database.structure.type.DoubleType;
import liquibase.database.structure.type.IntType;
import liquibase.database.structure.type.NVarcharType;
import liquibase.database.structure.type.TimeType;
import liquibase.database.structure.type.TinyIntType;
import liquibase.database.structure.type.UUIDType;
import liquibase.database.structure.type.VarcharType;
import liquibase.database.typeconversion.core.AbstractTypeConverter;

public class OracleTypeConverter
extends AbstractTypeConverter {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof OracleDatabase;
    }

    protected DataType getDataType(String columnTypeString, Boolean autoIncrement, String dataTypeName, String precision) {
        DataType returnTypeName = super.getDataType(columnTypeString, autoIncrement, dataTypeName, precision);
        if (returnTypeName instanceof CustomType && columnTypeString.toUpperCase().startsWith("VARCHAR2")) {
            returnTypeName = this.getVarcharType();
            if (precision != null) {
                String[] typeParams = precision.split(" ");
                returnTypeName.setFirstParameter(typeParams[0].trim());
                if (typeParams.length > 1) {
                    returnTypeName.setUnit(typeParams[1]);
                }
            }
        }
        return returnTypeName;
    }

    public Object convertDatabaseValueToObject(Object defaultValue, int dataType, int columnSize, int decimalDigits, Database database) throws ParseException {
        if (defaultValue != null && defaultValue instanceof String) {
            if (dataType == 91 || dataType == 92 || dataType == 93) {
                defaultValue = ((String)defaultValue).indexOf("YYYY-MM-DD HH") > 0 ? ((String)defaultValue).replaceFirst("^to_date\\('", "").replaceFirst("', 'YYYY-MM-DD HH24:MI:SS'\\)$", "") : (((String)defaultValue).indexOf("YYYY-MM-DD") > 0 ? ((String)defaultValue).replaceFirst("^to_date\\('", "").replaceFirst("', 'YYYY-MM-DD'\\)$", "") : ((String)defaultValue).replaceFirst("^to_date\\('", "").replaceFirst("', 'HH24:MI:SS'\\)$", ""));
            } else if (dataType == -5 || dataType == 2 || dataType == -7 || dataType == 5 || dataType == 3 || dataType == 4 || dataType == -6 || dataType == 6 || dataType == 7) {
                defaultValue = ((String)defaultValue).replaceFirst("\\(", "").replaceFirst("\\)", "");
            }
            defaultValue = ((String)defaultValue).replaceFirst("'\\s*$", "'");
        }
        return super.convertDatabaseValueToObject(defaultValue, dataType, columnSize, decimalDigits, database);
    }

    protected Object convertToCorrectObjectType(String value, int dataType, int columnSize, int decimalDigits, Database database) throws ParseException {
        Object returnValue = super.convertToCorrectObjectType(value, dataType, columnSize, decimalDigits, database);
        return returnValue;
    }

    public BooleanType getBooleanType() {
        return new BooleanType.NumericBooleanType("NUMBER(1)");
    }

    public CurrencyType getCurrencyType() {
        return new CurrencyType("NUMBER(15, 2)");
    }

    public UUIDType getUUIDType() {
        return new UUIDType("RAW(16)");
    }

    public TimeType getTimeType() {
        return new TimeType("DATE");
    }

    public DateTimeType getDateTimeType() {
        return new DateTimeType("TIMESTAMP");
    }

    public BigIntType getBigIntType() {
        return new BigIntType("NUMBER(38,0)");
    }

    public IntType getIntType() {
        return new IntType("INTEGER");
    }

    public VarcharType getVarcharType() {
        return new VarcharType("VARCHAR2");
    }

    public NVarcharType getNVarcharType() {
        return new NVarcharType("NVARCHAR2");
    }

    public DoubleType getDoubleType() {
        return new DoubleType("FLOAT(24)");
    }

    public TinyIntType getTinyIntType() {
        return new TinyIntType("NUMBER(3)");
    }
}

