/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.View;
import liquibase.diff.DiffComparison;
import liquibase.diff.DiffResult;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.DatabaseSnapshotGeneratorFactory;
import liquibase.util.StringUtils;

public class Diff {
    private Database referenceDatabase;
    private Database targetDatabase;
    private DatabaseSnapshot referenceSnapshot;
    private DatabaseSnapshot targetSnapshot;
    private Set<DiffStatusListener> statusListeners = new HashSet<DiffStatusListener>();
    private boolean diffTables = true;
    private boolean diffColumns = true;
    private boolean diffViews = true;
    private boolean diffPrimaryKeys = true;
    private boolean diffUniqueConstraints = true;
    private boolean diffIndexes = true;
    private boolean diffForeignKeys = true;
    private boolean diffSequences = true;
    private boolean diffData = false;

    public Diff(Database referenceDatabase, Database targetDatabase) {
        this.referenceDatabase = referenceDatabase;
        this.targetDatabase = targetDatabase;
    }

    public Diff(Database originalDatabase, String schema) throws DatabaseException {
        this.targetDatabase = null;
        this.referenceDatabase = originalDatabase;
        this.referenceDatabase.setDefaultSchemaName(schema);
    }

    public Diff(DatabaseSnapshot referenceSnapshot, DatabaseSnapshot targetDatabaseSnapshot) {
        this.referenceSnapshot = referenceSnapshot;
        this.targetSnapshot = targetDatabaseSnapshot;
    }

    public void addStatusListener(DiffStatusListener listener) {
        this.statusListeners.add(listener);
    }

    public void removeStatusListener(DiffStatusListener listener) {
        this.statusListeners.remove(listener);
    }

    public DiffResult compare() throws DatabaseException {
        if (this.referenceSnapshot == null) {
            this.referenceSnapshot = DatabaseSnapshotGeneratorFactory.getInstance().createSnapshot(this.referenceDatabase, null, this.statusListeners);
        }
        if (this.targetSnapshot == null) {
            this.targetSnapshot = this.targetDatabase == null ? new DatabaseSnapshot(this.referenceDatabase, null) : DatabaseSnapshotGeneratorFactory.getInstance().createSnapshot(this.targetDatabase, null, this.statusListeners);
        }
        DiffResult diffResult = new DiffResult(this.referenceSnapshot, this.targetSnapshot);
        this.checkVersionInfo(diffResult);
        if (this.shouldDiffTables()) {
            this.checkTables(diffResult);
        }
        if (this.shouldDiffViews()) {
            this.checkViews(diffResult);
        }
        if (this.shouldDiffColumns()) {
            this.checkColumns(diffResult);
        }
        if (this.shouldDiffForeignKeys()) {
            this.checkForeignKeys(diffResult);
        }
        if (this.shouldDiffPrimaryKeys()) {
            this.checkPrimaryKeys(diffResult);
        }
        if (this.shouldDiffUniqueConstraints()) {
            this.checkUniqueConstraints(diffResult);
        }
        if (this.shouldDiffIndexes()) {
            this.checkIndexes(diffResult);
        }
        if (this.shouldDiffSequences()) {
            this.checkSequences(diffResult);
        }
        diffResult.setDiffData(this.shouldDiffData());
        return diffResult;
    }

    public void setDiffTypes(String diffTypes) {
        if (StringUtils.trimToNull(diffTypes) != null) {
            HashSet<String> types = new HashSet<String>(Arrays.asList(diffTypes.toLowerCase().split("\\s*,\\s*")));
            this.diffTables = types.contains("tables");
            this.diffColumns = types.contains("columns");
            this.diffViews = types.contains("views");
            this.diffPrimaryKeys = types.contains("primaryKeys".toLowerCase());
            this.diffUniqueConstraints = types.contains("uniqueConstraints".toLowerCase());
            this.diffIndexes = types.contains("indexes");
            this.diffForeignKeys = types.contains("foreignKeys".toLowerCase());
            this.diffSequences = types.contains("sequences");
            this.diffData = types.contains("data");
        }
    }

    public boolean shouldDiffTables() {
        return this.diffTables;
    }

    public void setDiffTables(boolean diffTables) {
        this.diffTables = diffTables;
    }

    public boolean shouldDiffColumns() {
        return this.diffColumns;
    }

    public void setDiffColumns(boolean diffColumns) {
        this.diffColumns = diffColumns;
    }

    public boolean shouldDiffViews() {
        return this.diffViews;
    }

    public void setDiffViews(boolean diffViews) {
        this.diffViews = diffViews;
    }

    public boolean shouldDiffPrimaryKeys() {
        return this.diffPrimaryKeys;
    }

    public void setDiffPrimaryKeys(boolean diffPrimaryKeys) {
        this.diffPrimaryKeys = diffPrimaryKeys;
    }

    public boolean shouldDiffIndexes() {
        return this.diffIndexes;
    }

    public void setDiffIndexes(boolean diffIndexes) {
        this.diffIndexes = diffIndexes;
    }

    public boolean shouldDiffForeignKeys() {
        return this.diffForeignKeys;
    }

    public void setDiffForeignKeys(boolean diffForeignKeys) {
        this.diffForeignKeys = diffForeignKeys;
    }

    public boolean shouldDiffSequences() {
        return this.diffSequences;
    }

    public void setDiffSequences(boolean diffSequences) {
        this.diffSequences = diffSequences;
    }

    public boolean shouldDiffData() {
        return this.diffData;
    }

    public void setDiffData(boolean diffData) {
        this.diffData = diffData;
    }

    public boolean shouldDiffUniqueConstraints() {
        return this.diffUniqueConstraints;
    }

    public void setDiffUniqueConstraints(boolean diffUniqueConstraints) {
        this.diffUniqueConstraints = diffUniqueConstraints;
    }

    private void checkVersionInfo(DiffResult diffResult) throws DatabaseException {
        if (this.targetDatabase != null) {
            diffResult.setProductName(new DiffComparison(this.referenceDatabase.getDatabaseProductName(), this.targetDatabase.getDatabaseProductName()));
            diffResult.setProductVersion(new DiffComparison(this.referenceDatabase.getDatabaseProductVersion(), this.targetDatabase.getDatabaseProductVersion()));
        }
    }

    private void checkTables(DiffResult diffResult) {
        for (Table baseTable : this.referenceSnapshot.getTables()) {
            if (this.targetSnapshot.getTables().contains(baseTable)) continue;
            diffResult.addMissingTable(baseTable);
        }
        for (Table targetTable : this.targetSnapshot.getTables()) {
            if (this.referenceSnapshot.getTables().contains(targetTable)) continue;
            diffResult.addUnexpectedTable(targetTable);
        }
    }

    private void checkViews(DiffResult diffResult) {
        for (View baseView : this.referenceSnapshot.getViews()) {
            if (!this.targetSnapshot.getViews().contains(baseView)) {
                diffResult.addMissingView(baseView);
                continue;
            }
            Object targetView = null;
            for (View view : this.targetSnapshot.getViews()) {
                if (!view.getName().equals(baseView.getName()) || view.getDefinition().equals(baseView.getDefinition())) continue;
                diffResult.addChangedView(view);
            }
        }
        for (View targetView : this.targetSnapshot.getViews()) {
            if (!this.referenceSnapshot.getViews().contains(targetView)) {
                diffResult.addUnexpectedView(targetView);
                continue;
            }
            for (View view : this.targetSnapshot.getViews()) {
                if (!view.getName().equals(targetView.getName()) || view.getDefinition().equals(targetView.getDefinition())) continue;
                diffResult.addChangedView(view);
            }
        }
    }

    private void checkColumns(DiffResult diffResult) {
        for (Column baseColumn : this.referenceSnapshot.getColumns()) {
            if (this.targetSnapshot.getColumns().contains(baseColumn) || baseColumn.getTable() != null && diffResult.getMissingTables().contains(baseColumn.getTable()) || baseColumn.getView() != null && diffResult.getMissingViews().contains(baseColumn.getView())) continue;
            diffResult.addMissingColumn(baseColumn);
        }
        for (Column targetColumn : this.targetSnapshot.getColumns()) {
            Column baseColumn;
            if (!(this.referenceSnapshot.getColumns().contains(targetColumn) || targetColumn.getTable() != null && diffResult.getUnexpectedTables().contains(targetColumn.getTable()) || targetColumn.getView() != null && diffResult.getUnexpectedViews().contains(targetColumn.getView()))) {
                diffResult.addUnexpectedColumn(targetColumn);
                continue;
            }
            if (targetColumn.getTable() == null || diffResult.getUnexpectedTables().contains(targetColumn.getTable()) || (baseColumn = this.referenceSnapshot.getColumn(targetColumn.getTable().getName(), targetColumn.getName())) != null && !targetColumn.isDifferent(baseColumn)) continue;
            diffResult.addChangedColumn(targetColumn);
        }
    }

    private void checkForeignKeys(DiffResult diffResult) {
        for (ForeignKey baseFK : this.referenceSnapshot.getForeignKeys()) {
            if (this.targetSnapshot.getForeignKeys().contains(baseFK)) continue;
            diffResult.addMissingForeignKey(baseFK);
        }
        for (ForeignKey targetFK : this.targetSnapshot.getForeignKeys()) {
            if (this.referenceSnapshot.getForeignKeys().contains(targetFK)) continue;
            diffResult.addUnexpectedForeignKey(targetFK);
        }
    }

    private void checkUniqueConstraints(DiffResult diffResult) {
        for (UniqueConstraint baseIndex : this.referenceSnapshot.getUniqueConstraints()) {
            if (this.targetSnapshot.getUniqueConstraints().contains(baseIndex)) continue;
            diffResult.addMissingUniqueConstraint(baseIndex);
        }
        for (UniqueConstraint targetIndex : this.targetSnapshot.getUniqueConstraints()) {
            if (this.referenceSnapshot.getUniqueConstraints().contains(targetIndex)) continue;
            diffResult.addUnexpectedUniqueConstraint(targetIndex);
        }
    }

    private void checkIndexes(DiffResult diffResult) {
        for (Index baseIndex : this.referenceSnapshot.getIndexes()) {
            if (this.targetSnapshot.getIndexes().contains(baseIndex)) continue;
            diffResult.addMissingIndex(baseIndex);
        }
        for (Index targetIndex : this.targetSnapshot.getIndexes()) {
            if (this.referenceSnapshot.getIndexes().contains(targetIndex)) continue;
            diffResult.addUnexpectedIndex(targetIndex);
        }
    }

    private void checkPrimaryKeys(DiffResult diffResult) {
        for (PrimaryKey basePrimaryKey : this.referenceSnapshot.getPrimaryKeys()) {
            if (this.targetSnapshot.getPrimaryKeys().contains(basePrimaryKey)) continue;
            diffResult.addMissingPrimaryKey(basePrimaryKey);
        }
        for (PrimaryKey targetPrimaryKey : this.targetSnapshot.getPrimaryKeys()) {
            if (this.referenceSnapshot.getPrimaryKeys().contains(targetPrimaryKey)) continue;
            diffResult.addUnexpectedPrimaryKey(targetPrimaryKey);
        }
    }

    private void checkSequences(DiffResult diffResult) {
        for (Sequence baseSequence : this.referenceSnapshot.getSequences()) {
            if (this.targetSnapshot.getSequences().contains(baseSequence)) continue;
            diffResult.addMissingSequence(baseSequence);
        }
        for (Sequence targetSequence : this.targetSnapshot.getSequences()) {
            if (this.referenceSnapshot.getSequences().contains(targetSequence)) continue;
            diffResult.addUnexpectedSequence(targetSequence);
        }
    }
}

