/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.PrintStream;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.diff.Diff;
import liquibase.diff.DiffResult;
import liquibase.integration.ant.BaseLiquibaseTask;
import org.apache.tools.ant.BuildException;

public class GenerateChangeLogTask
extends BaseLiquibaseTask {
    private String diffTypes;

    public String getDiffTypes() {
        return this.diffTypes;
    }

    public void setDiffTypes(String diffTypes) {
        this.diffTypes = diffTypes;
    }

    public void execute() throws BuildException {
        Liquibase liquibase = null;
        try {
            PrintStream writer = this.createPrintStream();
            if (writer == null) {
                throw new BuildException("generateChangeLog requires outputFile to be set");
            }
            liquibase = this.createLiquibase();
            Database database = liquibase.getDatabase();
            Diff diff = new Diff(database, this.getDefaultSchemaName());
            if (this.getDiffTypes() != null) {
                diff.setDiffTypes(this.getDiffTypes());
            }
            DiffResult diffResult = diff.compare();
            if (this.getChangeLogFile() == null) {
                diffResult.printChangeLog(writer, database);
            } else {
                diffResult.printChangeLog(this.getChangeLogFile(), database);
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            try {
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeDatabase(liquibase);
                throw throwable;
            }
        }
        this.closeDatabase(liquibase);
    }
}

