/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging.jvm;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogLevel;
import liquibase.logging.core.AbstractLogger;

public class JavaUtilLogger
extends AbstractLogger {
    private Logger logger;

    public int getPriority() {
        return 5;
    }

    public void setName(String name) {
        this.logger = Logger.getLogger(name);
    }

    public void setLogLevel(LogLevel logLevel) {
        if (logLevel == LogLevel.DEBUG) {
            this.logger.setLevel(Level.FINEST);
        } else if (logLevel == LogLevel.INFO) {
            this.logger.setLevel(Level.INFO);
        } else if (logLevel == LogLevel.WARNING) {
            this.logger.setLevel(Level.WARNING);
        } else if (logLevel == LogLevel.SEVERE) {
            this.logger.setLevel(Level.SEVERE);
        } else if (logLevel == LogLevel.OFF) {
            this.logger.setLevel(Level.OFF);
        } else {
            throw new UnexpectedLiquibaseException("Unknown log level: " + (Object)((Object)logLevel));
        }
        super.setLogLevel(logLevel);
    }

    public void setLogLevel(String logLevel, String logFile) {
        FileHandler fH;
        try {
            fH = new FileHandler(logFile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot open log file " + logFile + ". Reason: " + e.getMessage());
        }
        fH.setFormatter(new Formatter(){

            public String format(LogRecord record) {
                return record.getLoggerName() + ":" + record.getLevel().getName() + ": " + record.getMessage();
            }
        });
        this.logger.addHandler(fH);
        this.logger.setUseParentHandlers(false);
        this.setLogLevel(logLevel);
    }

    public void severe(String message) {
        this.logger.severe(message);
    }

    public void severe(String message, Throwable e) {
        this.logger.log(Level.SEVERE, message, e);
    }

    public void warning(String message) {
        this.logger.warning(message);
    }

    public void warning(String message, Throwable e) {
        this.logger.log(Level.WARNING, message, e);
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void info(String message, Throwable e) {
        this.logger.log(Level.INFO, message, e);
    }

    public void debug(String message) {
        this.logger.finest(message);
    }

    public void debug(String message, Throwable e) {
        this.logger.log(Level.FINEST, message, e);
    }

    public Handler[] getHandlers() {
        return this.logger.getHandlers();
    }

    public void removeHandler(Handler handler) {
        this.logger.removeHandler(handler);
    }

    public void addHandler(Handler handler) {
        this.logger.addHandler(handler);
    }

    public void setUseParentHandlers(boolean b) {
        this.logger.setUseParentHandlers(b);
    }
}

