/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer.core.string;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import liquibase.change.Change;
import liquibase.change.ChangeProperty;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.custom.CustomChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.util.StringUtils;

public class StringChangeLogSerializer
implements ChangeLogSerializer {
    private static final int INDENT_LENGTH = 4;

    public String[] getValidFileExtensions() {
        return new String[]{"txt"};
    }

    public String serialize(DatabaseChangeLog databaseChangeLog) {
        return null;
    }

    public String serialize(Change change) {
        return change.getChangeMetaData().getName() + ":" + this.serializeObject(change, 1);
    }

    public String serialize(SqlVisitor visitor) {
        return visitor.getName() + ":" + this.serializeObject(visitor, 1);
    }

    private String serializeObject(Object objectToSerialize, int indent) {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            TreeSet<String> values = new TreeSet<String>();
            Class<?> classToCheck = objectToSerialize.getClass();
            while (!classToCheck.equals(Object.class)) {
                for (Field field : classToCheck.getDeclaredFields()) {
                    field.setAccessible(true);
                    ChangeProperty changePropertyAnnotation = field.getAnnotation(ChangeProperty.class);
                    if (changePropertyAnnotation != null && !changePropertyAnnotation.includeInSerialization() || field.getName().equals("serialVersionUID") || field.getName().equals("$VRc") || field.getName().equals("serialVersionUID")) continue;
                    String propertyName = field.getName();
                    Object value = field.get(objectToSerialize);
                    if (value instanceof ColumnConfig) {
                        values.add(this.indent(indent) + this.serializeColumnConfig((ColumnConfig)field.get(objectToSerialize), indent + 1));
                        continue;
                    }
                    if (value instanceof ConstraintsConfig) {
                        values.add(this.indent(indent) + this.serializeConstraintsConfig((ConstraintsConfig)field.get(objectToSerialize), indent + 1));
                        continue;
                    }
                    if (value instanceof CustomChange) {
                        values.add(this.indent(indent) + this.serializeCustomChange((CustomChange)field.get(objectToSerialize), indent + 1));
                        continue;
                    }
                    if (value == null) continue;
                    if (value instanceof Map) {
                        values.add(this.indent(indent) + propertyName + "=" + this.serializeObject((Map)value, indent + 1));
                        continue;
                    }
                    if (value instanceof Collection) {
                        values.add(this.indent(indent) + propertyName + "=" + this.serializeObject((Collection)value, indent + 1));
                        continue;
                    }
                    values.add(this.indent(indent) + propertyName + "=\"" + value.toString() + "\"");
                }
                classToCheck = classToCheck.getSuperclass();
            }
            if (values.size() > 0) {
                buffer.append("\n");
                buffer.append(StringUtils.join(values, "\n"));
                buffer.append("\n");
            }
            buffer.append(this.indent(indent - 1)).append("]");
            return buffer.toString();
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    private String indent(int indent) {
        return StringUtils.repeat(" ", 4 * indent);
    }

    private String serializeObject(Collection collection, int indent) {
        if (collection.size() == 0) {
            return "[]";
        }
        String returnString = "[\n";
        for (Object object : collection) {
            if (object instanceof ColumnConfig) {
                returnString = returnString + this.indent(indent) + this.serializeColumnConfig((ColumnConfig)object, indent + 1) + ",\n";
                continue;
            }
            returnString = returnString + this.indent(indent) + object.toString() + ",\n";
        }
        returnString = returnString.replaceFirst(",$", "");
        returnString = returnString + this.indent(indent - 1) + "]";
        return returnString;
    }

    private String serializeObject(Map collection, int indent) {
        if (collection.size() == 0) {
            return "[]";
        }
        String returnString = "{\n";
        for (Object key : new TreeSet(collection.keySet())) {
            returnString = returnString + this.indent(indent) + key.toString() + "=\"" + collection.get(key) + "\",\n";
        }
        returnString = returnString.replaceFirst(",$", "");
        returnString = returnString + this.indent(indent - 1) + "}";
        return returnString;
    }

    public String serialize(ColumnConfig columnConfig) {
        return null;
    }

    private String serializeColumnConfig(ColumnConfig columnConfig, int indent) {
        return "column:" + this.serializeObject(columnConfig, indent);
    }

    private String serializeConstraintsConfig(ConstraintsConfig constraintsConfig, int indent) {
        return "constraints:" + this.serializeObject(constraintsConfig, indent);
    }

    private String serializeCustomChange(CustomChange customChange, int indent) {
        return "customChange:" + this.serializeObject(customChange, indent);
    }

    public String serialize(ChangeSet changeSet) {
        return null;
    }
}

