/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.GetViewDefinitionGenerator;
import liquibase.statement.core.GetViewDefinitionStatement;

public class GetViewDefinitionGeneratorMSSQL
extends GetViewDefinitionGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(GetViewDefinitionStatement statement, Database database) {
        return database instanceof MSSQLDatabase;
    }

    public Sql[] generateSql(GetViewDefinitionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        try {
            String sql = "select view_definition from INFORMATION_SCHEMA.VIEWS where upper(table_name)='" + statement.getViewName().toUpperCase() + "'";
            sql = sql + " and table_schema='" + database.convertRequestedSchemaToSchema(statement.getSchemaName()) + "'";
            sql = sql + " and table_catalog='" + database.getDefaultCatalogName() + "'";
            return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }
}

