/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.DropTableChange;
import liquibase.database.Database;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.CreateTableStatement;
import liquibase.statement.core.SetColumnRemarksStatement;
import liquibase.statement.core.SetTableRemarksStatement;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableChange
extends AbstractChange
implements ChangeWithColumns {
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();
    private String schemaName;
    private String tableName;
    private String tablespace;
    private String remarks;

    public CreateTableChange() {
        super("createTable", "Create Table", 1);
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        String schemaName = this.getSchemaName() == null ? (database == null ? null : database.getDefaultSchemaName()) : this.getSchemaName();
        CreateTableStatement statement = new CreateTableStatement(schemaName, this.getTableName());
        for (ColumnConfig column : this.getColumns()) {
            ConstraintsConfig constraints = column.getConstraints();
            boolean isAutoIncrement = column.isAutoIncrement() != null && column.isAutoIncrement() != false;
            Object defaultValue = column.getDefaultValueObject();
            if (constraints != null && constraints.isPrimaryKey() != null && constraints.isPrimaryKey().booleanValue()) {
                statement.addPrimaryKeyColumn(column.getName(), TypeConverterFactory.getInstance().findTypeConverter(database).getDataType(column.getType(), isAutoIncrement), defaultValue, constraints.getPrimaryKeyName(), constraints.getPrimaryKeyTablespace(), new ColumnConstraint[0]);
            } else {
                statement.addColumn(column.getName(), TypeConverterFactory.getInstance().findTypeConverter(database).getDataType(column.getType(), column.isAutoIncrement()), defaultValue);
            }
            if (constraints != null) {
                if (constraints.isNullable() != null && !constraints.isNullable().booleanValue()) {
                    statement.addColumnConstraint(new NotNullConstraint(column.getName()));
                }
                if (constraints.getReferences() != null) {
                    if (StringUtils.trimToNull(constraints.getForeignKeyName()) == null) {
                        throw new UnexpectedLiquibaseException("createTable with references requires foreignKeyName");
                    }
                    ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint(constraints.getForeignKeyName(), constraints.getReferences());
                    fkConstraint.setColumn(column.getName());
                    fkConstraint.setDeleteCascade(constraints.isDeleteCascade() != null && constraints.isDeleteCascade() != false);
                    fkConstraint.setInitiallyDeferred(constraints.isInitiallyDeferred() != null && constraints.isInitiallyDeferred() != false);
                    fkConstraint.setDeferrable(constraints.isDeferrable() != null && constraints.isDeferrable() != false);
                    statement.addColumnConstraint(fkConstraint);
                }
                if (constraints.isUnique() != null && constraints.isUnique().booleanValue()) {
                    statement.addColumnConstraint(new UniqueConstraint(constraints.getUniqueConstraintName()).addColumns(column.getName()));
                }
            }
            if (!isAutoIncrement) continue;
            statement.addColumnConstraint(new AutoIncrementConstraint(column.getName()));
        }
        statement.setTablespace(StringUtils.trimToNull(this.getTablespace()));
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        statements.add(statement);
        if (StringUtils.trimToNull(this.remarks) != null) {
            SetTableRemarksStatement remarksStatement = new SetTableRemarksStatement(schemaName, this.tableName, this.remarks);
            if (SqlGeneratorFactory.getInstance().supports(remarksStatement, database)) {
                statements.add(remarksStatement);
            }
        }
        for (ColumnConfig column : this.getColumns()) {
            String columnRemarks = StringUtils.trimToNull(column.getRemarks());
            if (columnRemarks == null) continue;
            SetColumnRemarksStatement remarksStatement = new SetColumnRemarksStatement(schemaName, this.tableName, column.getName(), columnRemarks);
            if (!SqlGeneratorFactory.getInstance().supports(remarksStatement, database)) continue;
            statements.add(remarksStatement);
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    protected Change[] createInverses() {
        DropTableChange inverse = new DropTableChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        return new Change[]{inverse};
    }

    @Override
    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public String getConfirmationMessage() {
        return "Table " + this.tableName + " created";
    }
}

