/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;

public class ChangeLogIterator {
    private DatabaseChangeLog databaseChangeLog;
    private List<ChangeSetFilter> changeSetFilters;

    public ChangeLogIterator(DatabaseChangeLog databaseChangeLog, ChangeSetFilter ... changeSetFilters) {
        this.databaseChangeLog = databaseChangeLog;
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    public void run(ChangeSetVisitor visitor, Database database) throws LiquibaseException {
        List<ChangeSet> changeSetList = this.databaseChangeLog.getChangeSets();
        if (visitor.getDirection().equals((Object)ChangeSetVisitor.Direction.REVERSE)) {
            Collections.reverse(changeSetList);
        }
        for (ChangeSet changeSet : changeSetList) {
            boolean shouldVisit = true;
            if (this.changeSetFilters != null) {
                for (ChangeSetFilter filter : this.changeSetFilters) {
                    if (filter.accepts(changeSet)) continue;
                    shouldVisit = false;
                    break;
                }
            }
            if (!shouldVisit) continue;
            visitor.visit(changeSet, this.databaseChangeLog, database);
        }
    }
}

