/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.database.structure.Column;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.ForeignKeyConstraintType;
import liquibase.database.structure.ForeignKeyInfo;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.jvm.JdbcDatabaseSnapshotGenerator;
import liquibase.util.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseSnapshotGenerator
extends JdbcDatabaseSnapshotGenerator {
    private List<String> integerList = new ArrayList<String>();

    @Override
    public boolean supports(Database database) {
        return database instanceof OracleDatabase;
    }

    @Override
    public int getPriority(Database database) {
        return 5;
    }

    @Override
    protected String convertTableNameToDatabaseTableName(String tableName) {
        return tableName.toUpperCase();
    }

    @Override
    protected String convertColumnNameToDatabaseTableName(String columnName) {
        return columnName.toUpperCase();
    }

    @Override
    protected void getColumnTypeAndDefValue(Column columnInfo, ResultSet rs, Database database) throws SQLException, DatabaseException {
        String columnTypeName;
        super.getColumnTypeAndDefValue(columnInfo, rs, database);
        if (columnInfo.getDataType() == 4) {
            columnInfo.setTypeName("INTEGER");
        }
        if ("VARCHAR2".equals(columnTypeName = rs.getString("TYPE_NAME"))) {
            int charOctetLength = rs.getInt("CHAR_OCTET_LENGTH");
            int columnSize = rs.getInt("COLUMN_SIZE");
            if (columnSize == charOctetLength) {
                columnInfo.setLengthSemantics(Column.LengthSemantics.BYTE);
            } else {
                columnInfo.setLengthSemantics(Column.LengthSemantics.CHAR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readUniqueConstraints(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws DatabaseException, SQLException {
        Database database = snapshot.getDatabase();
        this.updateListeners("Reading unique constraints for " + database.toString() + " ...");
        ArrayList<UniqueConstraint> foundUC = new ArrayList<UniqueConstraint>();
        Connection jdbcConnection = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        if (schema == null) {
            schema = database.convertRequestedSchemaToSchema(schema);
        }
        try {
            String query = "select uc.constraint_name,uc.table_name,uc.status,uc.deferrable,uc.deferred,ui.tablespace_name from user_constraints uc, user_cons_columns ucc, user_indexes ui where uc.constraint_type='U' and uc.index_name = ui.index_name and uc.constraint_name = ucc.constraint_name";
            statement = jdbcConnection.prepareStatement(query);
            rs = statement.executeQuery();
            while (rs.next()) {
                Table table;
                String constraintName = rs.getString("constraint_name");
                String tableName = rs.getString("table_name");
                String status = rs.getString("status");
                String deferrable = rs.getString("deferrable");
                String deferred = rs.getString("deferred");
                String tablespace = rs.getString("tablespace_name");
                UniqueConstraint constraintInformation = new UniqueConstraint();
                constraintInformation.setName(constraintName);
                constraintInformation.setTablespace(tablespace);
                if (database.isSystemTable(null, schema, tableName) || database.isLiquibaseTable(tableName) || (table = snapshot.getTable(tableName)) == null) continue;
                constraintInformation.setTable(table);
                constraintInformation.setDisabled("DISABLED".equals(status));
                if ("DEFERRABLE".equals(deferrable)) {
                    constraintInformation.setDeferrable(true);
                    constraintInformation.setInitiallyDeferred("DEFERRED".equals(deferred));
                }
                this.getColumnsForUniqueConstraint(jdbcConnection, constraintInformation);
                foundUC.add(constraintInformation);
            }
            snapshot.getUniqueConstraints().addAll(foundUC);
        }
        finally {
            rs.close();
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getColumnsForUniqueConstraint(Connection jdbcConnection, UniqueConstraint constraint) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = jdbcConnection.prepareStatement("select column_name from user_cons_columns where constraint_name=? order by position");
            stmt.setString(1, constraint.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString("column_name");
                constraint.getColumns().add(columnName);
            }
        }
        finally {
            rs.close();
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    protected void readColumns(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws SQLException, DatabaseException {
        this.findIntegerColumns(snapshot);
        super.readColumns(snapshot, schema, databaseMetaData);
        Database database = snapshot.getDatabase();
        Statement statement = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().createStatement();
        String query = "select ui.tablespace_name TABLESPACE, ucc.table_name TABLE_NAME, ucc.column_name COLUMN_NAME FROM user_indexes ui , user_constraints uc , user_cons_columns ucc where uc.constraint_type = 'P' and ucc.constraint_name = uc.constraint_name and uc.index_name = ui.index_name";
        ResultSet rs = statement.executeQuery(query);
        while (rs.next()) {
            Column column = snapshot.getColumn(rs.getString("TABLE_NAME"), rs.getString("COLUMN_NAME"));
            if (column == null) continue;
            column.setTablespace(rs.getString("TABLESPACE"));
        }
    }

    private List<String> findIntegerColumns(DatabaseSnapshot snapshot) throws SQLException {
        Database database = snapshot.getDatabase();
        Statement statement = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().createStatement();
        ResultSet integerListRS = statement.executeQuery("select * from user_tab_columns where data_precision is null and data_scale = 0 and data_type = 'NUMBER'");
        while (integerListRS.next()) {
            this.integerList.add(integerListRS.getString("TABLE_NAME") + "." + integerListRS.getString("COLUMN_NAME"));
        }
        JdbcUtils.closeResultSet(integerListRS);
        JdbcUtils.closeStatement(statement);
        return this.integerList;
    }

    @Override
    protected void configureColumnType(Column column, ResultSet rs) throws SQLException {
        if (this.integerList.contains(column.getTable().getName() + "." + column.getName())) {
            column.setDataType(4);
        } else {
            column.setDataType(rs.getInt("DATA_TYPE"));
        }
        column.setColumnSize(rs.getInt("COLUMN_SIZE"));
        column.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
        column.setInitPrecision(column.getDataType() != 3 && column.getDataType() != 2 && column.getDataType() != 7 || rs.getString("DECIMAL_DIGITS") != null);
    }

    @Override
    public List<ForeignKey> getAdditionalForeignKeys(String schemaName, Database database) throws DatabaseException {
        List<ForeignKey> foreignKeys = super.getAdditionalForeignKeys(schemaName, database);
        String query = "select uc_fk.constraint_name FK_NAME,uc_fk.owner FKTABLE_SCHEM,ucc_fk.table_name FKTABLE_NAME,ucc_fk.column_name FKCOLUMN_NAME,decode(uc_fk.deferrable, 'DEFERRABLE', 5 ,'NOT DEFERRABLE', 7 , 'DEFERRED', 6 ) DEFERRABILITY, decode(uc_fk.delete_rule, 'CASCADE', 0,'NO ACTION', 3) DELETE_RULE,ucc_rf.table_name PKTABLE_NAME,ucc_rf.column_name PKCOLUMN_NAME from user_cons_columns ucc_fk,user_constraints uc_fk,user_cons_columns ucc_rf,user_constraints uc_rf where uc_fk.CONSTRAINT_NAME = ucc_fk.CONSTRAINT_NAME and uc_fk.constraint_type='R' and uc_fk.r_constraint_name=ucc_rf.CONSTRAINT_NAME and uc_rf.constraint_name = ucc_rf.constraint_name and uc_rf.constraint_type = 'U'";
        try {
            Statement statement = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().createStatement();
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                ForeignKeyInfo fkInfo = new ForeignKeyInfo();
                fkInfo.setReferencesUniqueColumn(true);
                fkInfo.setFkName(this.convertFromDatabaseName(rs.getString("FK_NAME")));
                fkInfo.setFkSchema(this.convertFromDatabaseName(rs.getString("FKTABLE_SCHEM")));
                fkInfo.setFkTableName(this.convertFromDatabaseName(rs.getString("FKTABLE_NAME")));
                fkInfo.setFkColumn(this.convertFromDatabaseName(rs.getString("FKCOLUMN_NAME")));
                fkInfo.setPkTableName(this.convertFromDatabaseName(rs.getString("PKTABLE_NAME")));
                fkInfo.setPkColumn(this.convertFromDatabaseName(rs.getString("PKCOLUMN_NAME")));
                fkInfo.setDeferrablility(rs.getShort("DEFERRABILITY"));
                ForeignKeyConstraintType deleteRule = this.convertToForeignKeyConstraintType(rs.getInt("DELETE_RULE"));
                if (rs.wasNull()) {
                    deleteRule = null;
                }
                fkInfo.setDeleteRule(deleteRule);
                foreignKeys.add(this.generateForeignKey(fkInfo, database, foreignKeys));
            }
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement(statement);
        }
        catch (SQLException e) {
            throw new DatabaseException("Can't execute selection query to generate list of foreign keys", e);
        }
        return foreignKeys;
    }

    @Override
    protected void readIndexes(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws DatabaseException, SQLException {
        Database database = snapshot.getDatabase();
        this.updateListeners("Reading indexes for " + database.toString() + " ...");
        String query = "select aic.index_name, 3 AS TYPE, aic.table_name, aic.column_name, aic.column_position AS ORDINAL_POSITION, null AS FILTER_CONDITION, ai.tablespace_name AS TABLESPACE FROM all_ind_columns aic, all_indexes ai WHERE aic.table_owner='" + database.convertRequestedSchemaToSchema(schema) + "' and aic.index_name = ai.index_name ORDER BY INDEX_NAME, ORDINAL_POSITION";
        Statement statement = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().createStatement();
        ResultSet rs = statement.executeQuery(query);
        HashMap<String, Index> indexMap = new HashMap<String, Index>();
        while (rs.next()) {
            Index index;
            String indexName = this.convertFromDatabaseName(rs.getString("INDEX_NAME"));
            String tableName = rs.getString("TABLE_NAME");
            String tableSpace = rs.getString("TABLESPACE");
            String columnName = this.convertFromDatabaseName(rs.getString("COLUMN_NAME"));
            if (columnName == null) continue;
            short type = rs.getShort("TYPE");
            boolean nonUnique = true;
            try {
                nonUnique = rs.getBoolean("NON_UNIQUE");
            }
            catch (SQLException e) {
                // empty catch block
            }
            short position = rs.getShort("ORDINAL_POSITION");
            String filterCondition = rs.getString("FILTER_CONDITION");
            if (type == 0) continue;
            if (indexMap.containsKey(indexName)) {
                index = (Index)indexMap.get(indexName);
            } else {
                index = new Index();
                Table table = snapshot.getTable(tableName);
                if (table == null) continue;
                index.setTable(table);
                index.setTablespace(tableSpace);
                index.setName(indexName);
                index.setUnique(!nonUnique);
                index.setFilterCondition(filterCondition);
                indexMap.put(indexName, index);
            }
            for (int i = index.getColumns().size(); i < position; ++i) {
                index.getColumns().add(null);
            }
            index.getColumns().set(position - 1, columnName);
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(statement);
        for (Map.Entry entry : indexMap.entrySet()) {
            snapshot.getIndexes().add((Index)entry.getValue());
        }
        for (Index index : snapshot.getIndexes()) {
            for (PrimaryKey pk : snapshot.getPrimaryKeys()) {
                if (!index.getTable().getName().equalsIgnoreCase(pk.getTable().getName()) || !index.getColumnNames().equals(pk.getColumnNames())) continue;
                index.addAssociatedWith("primaryKey");
            }
            for (ForeignKey fk : snapshot.getForeignKeys()) {
                if (!index.getTable().getName().equalsIgnoreCase(fk.getForeignKeyTable().getName()) || !index.getColumnNames().equals(fk.getForeignKeyColumns())) continue;
                index.addAssociatedWith("foreignKey");
            }
            for (UniqueConstraint uc : snapshot.getUniqueConstraints()) {
                if (!index.getTable().getName().equalsIgnoreCase(uc.getTable().getName()) || !index.getColumnNames().equals(uc.getColumnNames())) continue;
                index.addAssociatedWith("uniqueConstraint");
            }
        }
    }

    @Override
    protected void readPrimaryKeys(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws DatabaseException, SQLException {
        Database database = snapshot.getDatabase();
        this.updateListeners("Reading primary keys for " + database.toString() + " ...");
        ArrayList<PrimaryKey> foundPKs = new ArrayList<PrimaryKey>();
        String query = "select uc.table_name TABLE_NAME,ucc.column_name COLUMN_NAME,ucc.position KEY_SEQ,uc.constraint_name PK_NAME,ui.tablespace_name TABLESPACE from user_constraints uc,user_indexes ui,user_cons_columns ucc where uc.constraint_type = 'P' and uc.index_name = ui.index_name and uc.constraint_name = ucc.constraint_name";
        Statement statement = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().createStatement();
        ResultSet rs = statement.executeQuery(query);
        while (rs.next()) {
            String tableName = this.convertFromDatabaseName(rs.getString("TABLE_NAME"));
            String tablespace = this.convertFromDatabaseName(rs.getString("TABLESPACE"));
            String columnName = this.convertFromDatabaseName(rs.getString("COLUMN_NAME"));
            short position = rs.getShort("KEY_SEQ");
            boolean foundExistingPK = false;
            for (PrimaryKey pk : foundPKs) {
                if (!pk.getTable().getName().equals(tableName)) continue;
                pk.addColumnName(position - 1, columnName);
                foundExistingPK = true;
            }
            if (foundExistingPK || database.isLiquibaseTable(tableName)) continue;
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.setTablespace(tablespace);
            Table table = snapshot.getTable(tableName);
            if (table == null) continue;
            primaryKey.setTable(table);
            primaryKey.addColumnName(position - 1, columnName);
            primaryKey.setName(this.convertPrimaryKeyName(rs.getString("PK_NAME")));
            foundPKs.add(primaryKey);
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(statement);
        snapshot.getPrimaryKeys().addAll(foundPKs);
    }
}

