/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.logging.LogFactory;
import liquibase.sql.Sql;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CommentStatement;
import liquibase.statement.core.RuntimeStatement;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

public class ExecuteShellCommandChange
extends AbstractChange {
    private String executable;
    private List<String> os;
    private List<String> args = new ArrayList<String>();

    public ExecuteShellCommandChange() {
        super("executeCommand", "Execute Shell Command", 1);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void addArg(String arg) {
        this.args.add(arg);
    }

    public void setOs(String os) {
        this.os = StringUtils.splitAndTrim(os, ",");
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    public Warnings warn(Database database) {
        return new Warnings();
    }

    public SqlStatement[] generateStatements(Database database) {
        String currentOS;
        boolean shouldRun = true;
        if (this.os != null && this.os.size() > 0 && !this.os.contains(currentOS = System.getProperty("os.name"))) {
            shouldRun = false;
            LogFactory.getLogger().info("Not executing on os " + currentOS + " when " + this.os + " was specified");
        }
        boolean nonExecutedMode = false;
        Executor executor = ExecutorService.getInstance().getExecutor(database);
        if (executor instanceof LoggingExecutor) {
            nonExecutedMode = true;
        }
        if (shouldRun && !nonExecutedMode) {
            return new SqlStatement[]{new RuntimeStatement(){

                public Sql[] generate(Database database) {
                    ArrayList<String> commandArray = new ArrayList<String>();
                    commandArray.add(ExecuteShellCommandChange.this.executable);
                    commandArray.addAll(ExecuteShellCommandChange.this.args);
                    try {
                        ProcessBuilder pb = new ProcessBuilder(commandArray);
                        pb.redirectErrorStream(true);
                        Process p = pb.start();
                        int returnCode = 0;
                        try {
                            returnCode = p.waitFor();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
                        ByteArrayOutputStream inputStream = new ByteArrayOutputStream();
                        StreamUtil.copy(p.getErrorStream(), errorStream);
                        StreamUtil.copy(p.getInputStream(), inputStream);
                        LogFactory.getLogger().severe(errorStream.toString());
                        LogFactory.getLogger().info(inputStream.toString());
                        if (returnCode != 0) {
                            throw new RuntimeException(ExecuteShellCommandChange.this.getCommandString() + " returned an code of " + returnCode);
                        }
                    }
                    catch (IOException e) {
                        throw new UnexpectedLiquibaseException("Error executing command: " + e);
                    }
                    return null;
                }
            }};
        }
        if (nonExecutedMode) {
            return new SqlStatement[]{new CommentStatement(this.getCommandString())};
        }
        return new SqlStatement[0];
    }

    public String getConfirmationMessage() {
        return "Shell command '" + this.getCommandString() + "' executed";
    }

    private String getCommandString() {
        return this.executable + " " + StringUtils.join(this.args, " ");
    }
}

