/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.Date;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;

public class RanChangeSet {
    private final String changeLog;
    private final String id;
    private final String author;
    private final CheckSum lastCheckSum;
    private final Date dateExecuted;
    private String tag;
    private ChangeSet.ExecType execType;

    public RanChangeSet(ChangeSet changeSet) {
        this(changeSet.getFilePath(), changeSet.getId(), changeSet.getAuthor(), changeSet.generateCheckSum(), new Date(), null, null);
    }

    public RanChangeSet(String changeLog, String id, String author, CheckSum lastCheckSum, Date dateExecuted, String tag, ChangeSet.ExecType execType) {
        this.changeLog = changeLog;
        this.id = id;
        this.author = author;
        this.lastCheckSum = lastCheckSum;
        this.dateExecuted = dateExecuted == null ? null : new Date(dateExecuted.getTime());
        this.tag = tag;
        this.execType = execType;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public CheckSum getLastCheckSum() {
        return this.lastCheckSum;
    }

    public Date getDateExecuted() {
        if (this.dateExecuted == null) {
            return null;
        }
        return (Date)this.dateExecuted.clone();
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public ChangeSet.ExecType getExecType() {
        return this.execType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RanChangeSet that = (RanChangeSet)o;
        return this.author.equals(that.author) && this.changeLog.equals(that.changeLog) && this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.changeLog.hashCode();
        result = 29 * result + this.id.hashCode();
        result = 29 * result + this.author.hashCode();
        return result;
    }

    public boolean isSameAs(ChangeSet changeSet) {
        return this.getChangeLog().replace('\\', '/').equalsIgnoreCase(changeSet.getFilePath().replace('\\', '/')) && this.getId().equalsIgnoreCase(changeSet.getId()) && this.getAuthor().equalsIgnoreCase(changeSet.getAuthor());
    }
}

