/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure.type;

import liquibase.database.Database;
import liquibase.database.structure.type.DataType;
import liquibase.database.typeconversion.TypeConverter;
import liquibase.database.typeconversion.TypeConverterFactory;

public class BooleanType
extends DataType {
    public BooleanType() {
        super("BOOLEAN", 0, 0);
    }

    public BooleanType(String dataTypeName) {
        super(dataTypeName, 0, 0);
    }

    public String convertObjectToString(Object value, Database database) {
        if (value == null) {
            return null;
        }
        if (value.toString().equalsIgnoreCase("null")) {
            return "null";
        }
        TypeConverter converter = TypeConverterFactory.getInstance().findTypeConverter(database);
        String returnValue = (Boolean)value != false ? converter.getBooleanType().getTrueBooleanValue() : converter.getBooleanType().getFalseBooleanValue();
        if (returnValue.matches("\\d+")) {
            return returnValue;
        }
        return "'" + returnValue + "'";
    }

    public String getFalseBooleanValue() {
        return "FALSE";
    }

    public String getTrueBooleanValue() {
        return "TRUE";
    }

    public static class NumericBooleanType
    extends BooleanType {
        public NumericBooleanType() {
            super("INT");
        }

        public NumericBooleanType(String dataTypeName) {
            super(dataTypeName);
        }

        public String getFalseBooleanValue() {
            return "0";
        }

        public String getTrueBooleanValue() {
            return "1";
        }
    }
}

